/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter.function;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.kylin.metadata.filter.function.Like;

public enum BuiltInMethod {
    UPPER(BuiltInMethod.class, "upper", String.class),
    LOWER(BuiltInMethod.class, "lower", String.class),
    SUBSTRING(BuiltInMethod.class, "substring", String.class, Integer.TYPE, Integer.TYPE),
    CHAR_LENGTH(BuiltInMethod.class, "charLength", String.class),
    LIKE(BuiltInMethod.class, "like", String.class, String.class),
    INITCAP(BuiltInMethod.class, "initcap", String.class);

    public final Method method;
    public static final ImmutableMap<String, BuiltInMethod> MAP;

    private BuiltInMethod(Class<?> clazz, String methodName, Class<?> ... argumentTypes) {
        this.method = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])argumentTypes);
    }

    public static boolean like(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String substring(String s, int from, int for_) {
        return s.substring(from - 1, Math.min(from - 1 + for_, s.length()));
    }

    public static String upper(String s) {
        return s.toUpperCase();
    }

    public static String lower(String s) {
        return s.toLowerCase();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BuiltInMethod value : BuiltInMethod.values()) {
            if (value.method == null) continue;
            builder.put((Object)value.name(), (Object)value);
        }
        MAP = builder.build();
    }
}

