/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.LongMutable;

public class LongSerializer
extends DataTypeSerializer<LongMutable> {
    private ThreadLocal<LongMutable> current = new ThreadLocal();

    public LongSerializer(DataType type) {
    }

    @Override
    public void serialize(LongMutable value, ByteBuffer out) {
        BytesUtil.writeVLong(value.get(), out);
    }

    private LongMutable current() {
        LongMutable l = this.current.get();
        if (l == null) {
            l = new LongMutable();
            this.current.set(l);
        }
        return l;
    }

    @Override
    public LongMutable deserialize(ByteBuffer in) {
        LongMutable l = this.current();
        l.set(BytesUtil.readVLong(in));
        return l;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        BytesUtil.readVLong(in);
        int len = in.position() - mark;
        in.position(mark);
        return len;
    }

    @Override
    public int maxLength() {
        return 9;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 5;
    }

    @Override
    public LongMutable valueOf(String str) {
        return new LongMutable(Long.parseLong(str));
    }
}

