/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.LongMutable;

public class BooleanSerializer
extends DataTypeSerializer<LongMutable> {
    final String[] TRUE_VALUE_SET = new String[]{"true", "t", "on", "yes"};
    private ThreadLocal<LongMutable> current = new ThreadLocal();

    public BooleanSerializer(DataType type) {
    }

    @Override
    public void serialize(LongMutable value, ByteBuffer out) {
        out.putLong(value.get());
    }

    private LongMutable current() {
        LongMutable l = this.current.get();
        if (l == null) {
            l = new LongMutable();
            this.current.set(l);
        }
        return l;
    }

    @Override
    public LongMutable deserialize(ByteBuffer in) {
        LongMutable l = this.current();
        l.set(in.getLong());
        return l;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 8;
    }

    @Override
    public int maxLength() {
        return 8;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public LongMutable valueOf(String str) {
        LongMutable l = this.current();
        if (str == null) {
            l.set(0L);
        } else {
            l.set(BooleanUtils.toInteger((boolean)ArrayUtils.contains((Object[])this.TRUE_VALUE_SET, (Object)str.toLowerCase())));
        }
        return l;
    }
}

