/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.measure.topn.DoublyLinkedList;
import org.apache.kylin.measure.topn.ListNode2;

public class TopNCounter<T>
implements Iterable<Counter<T>> {
    public static final int EXTRA_SPACE_RATE = 50;
    protected int capacity;
    private HashMap<T, ListNode2<Counter<T>>> counterMap;
    protected DoublyLinkedList<Counter<T>> counterList;

    public TopNCounter(int capacity) {
        this.capacity = capacity;
        this.counterMap = new HashMap();
        this.counterList = new DoublyLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean offer(T item) {
        return this.offer(item, 1.0);
    }

    public boolean offer(T item, double incrementCount) {
        return this.offerReturnAll(item, incrementCount).getFirst();
    }

    public T offerReturnDropped(T item, double incrementCount) {
        return this.offerReturnAll(item, incrementCount).getSecond();
    }

    public Pair<Boolean, T> offerReturnAll(T item, double incrementCount) {
        ListNode2<Counter<T>> counterNode = this.counterMap.get(item);
        boolean isNewItem = counterNode == null;
        Object droppedItem = null;
        if (isNewItem) {
            if (this.size() < this.capacity) {
                counterNode = this.counterList.enqueue(new Counter<T>(item));
            } else {
                counterNode = this.counterList.tail();
                Counter<T> counter = counterNode.getValue();
                droppedItem = counter.item;
                this.counterMap.remove(droppedItem);
                counter.item = item;
                counter.count = 0.0;
            }
            this.counterMap.put(item, counterNode);
        }
        this.incrementCounter(counterNode, incrementCount);
        return Pair.newPair(isNewItem, droppedItem);
    }

    protected void incrementCounter(ListNode2<Counter<T>> counterNode, double incrementCount) {
        ListNode2<Counter<Object>> nodeNext;
        Counter<T> counter = counterNode.getValue();
        counter.count += incrementCount;
        this.counterList.remove(counterNode);
        counterNode.prev = null;
        counterNode.next = null;
        if (incrementCount > 0.0) {
            for (nodeNext = incrementCount > 0.0 ? counterNode.getNext() : counterNode.getPrev(); nodeNext != null && counter.count >= nodeNext.getValue().count; nodeNext = nodeNext.getNext()) {
            }
            if (nodeNext != null) {
                this.counterList.addBefore(nodeNext, counterNode);
            } else {
                this.counterList.add(counterNode);
            }
        } else {
            while (nodeNext != null && counter.count < nodeNext.getValue().count) {
                nodeNext = nodeNext.getPrev();
            }
            if (nodeNext != null) {
                this.counterList.addAfter(nodeNext, counterNode);
            } else {
                this.counterList.enqueue(counterNode);
            }
        }
    }

    public List<T> peek(int k) {
        ArrayList topK = new ArrayList(k);
        for (ListNode2<Counter<T>> bNode = this.counterList.head(); bNode != null; bNode = bNode.getPrev()) {
            Counter<T> b = bNode.getValue();
            if (topK.size() == k) {
                return topK;
            }
            topK.add(b.item);
        }
        return topK;
    }

    public List<Counter<T>> topK(int k) {
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (ListNode2<Counter<T>> bNode = this.counterList.head(); bNode != null; bNode = bNode.getPrev()) {
            Counter<T> b = bNode.getValue();
            if (topK.size() == k) {
                return topK;
            }
            topK.add(b);
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (ListNode2<Counter<T>> bNode = this.counterList.head(); bNode != null; bNode = bNode.getPrev()) {
            Counter<T> b = bNode.getValue();
            sb.append(b.item);
            sb.append(':');
            sb.append(b.count);
        }
        sb.append(']');
        return sb.toString();
    }

    public void offerToHead(T item, double count) {
        Counter<T> c = new Counter<T>(item);
        c.count = count;
        ListNode2<Counter<T>> node = this.counterList.add(c);
        this.counterMap.put(c.item, node);
    }

    public TopNCounter<T> merge(TopNCounter<T> another) {
        Object item;
        double m1 = 0.0;
        double m2 = 0.0;
        if (this.size() >= this.capacity) {
            m1 = this.counterList.tail().getValue().count;
        }
        if (another.size() >= another.capacity) {
            m2 = another.counterList.tail().getValue().count;
        }
        HashSet duplicateItems = Sets.newHashSet();
        ArrayList notDuplicateItems = Lists.newArrayList();
        for (Map.Entry<Object, ListNode2<Counter<Object>>> entry : this.counterMap.entrySet()) {
            item = entry.getKey();
            ListNode2<Counter<T>> existing = another.counterMap.get(item);
            if (existing != null) {
                duplicateItems.add(item);
                continue;
            }
            notDuplicateItems.add(item);
        }
        for (Map.Entry<Object, ListNode2<Counter<Object>>> item2 : duplicateItems) {
            this.offer(item2, another.counterMap.get(item2).getValue().count);
        }
        for (Map.Entry<Object, ListNode2<Counter<Object>>> item2 : notDuplicateItems) {
            this.offer(item2, m2);
        }
        for (Map.Entry<Object, ListNode2<Counter<Object>>> entry : another.counterMap.entrySet()) {
            item = entry.getKey();
            if (duplicateItems.contains(item)) continue;
            double counter = entry.getValue().getValue().count;
            this.offer(item, counter + m1);
        }
        return this;
    }

    public void retain(int newCapacity) {
        assert (newCapacity > 0);
        this.capacity = newCapacity;
        if (newCapacity < this.size()) {
            ListNode2<Counter<T>> tail = this.counterList.tail();
            while (tail != null && this.size() > newCapacity) {
                Counter<T> bucket = tail.getValue();
                this.counterMap.remove(bucket.getItem());
                this.counterList.remove(tail);
                tail = this.counterList.tail();
            }
        }
    }

    public double[] getCounters() {
        double[] counters = new double[this.size()];
        int index = 0;
        for (ListNode2<Counter<T>> bNode = this.counterList.tail(); bNode != null; bNode = bNode.getNext()) {
            Counter<T> b = bNode.getValue();
            counters[index] = b.count;
            ++index;
        }
        assert (index == this.size());
        return counters;
    }

    @Override
    public Iterator<Counter<T>> iterator() {
        return new TopNCounterIterator();
    }

    private class TopNCounterIterator
    implements Iterator<Counter<T>> {
        private ListNode2<Counter<T>> currentBNode;

        private TopNCounterIterator() {
            this.currentBNode = TopNCounter.this.counterList.tail();
        }

        @Override
        public boolean hasNext() {
            return this.currentBNode != null;
        }

        @Override
        public Counter<T> next() {
            Counter counter = this.currentBNode.getValue();
            this.currentBNode = this.currentBNode.getNext();
            return counter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

