/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import org.apache.kylin.measure.topn.ListNode2;

public class DoublyLinkedList<T> {
    private int size = 0;
    private ListNode2<T> tail;
    private ListNode2<T> head;

    public ListNode2<T> add(T value) {
        ListNode2<T> node = new ListNode2<T>(value);
        this.add(node);
        return node;
    }

    public ListNode2<T> enqueue(T value) {
        ListNode2<T> node = new ListNode2<T>(value);
        return this.enqueue(node);
    }

    public ListNode2<T> enqueue(ListNode2<T> node) {
        if (this.size++ == 0) {
            this.head = node;
        } else {
            node.next = this.tail;
            this.tail.prev = node;
        }
        this.tail = node;
        return node;
    }

    public void add(ListNode2<T> node) {
        node.prev = this.head;
        node.next = null;
        if (this.size++ == 0) {
            this.tail = node;
        } else {
            this.head.next = node;
        }
        this.head = node;
    }

    public ListNode2<T> addAfter(ListNode2<T> node, T value) {
        ListNode2<T> newNode = new ListNode2<T>(value);
        this.addAfter(node, newNode);
        return newNode;
    }

    public void addAfter(ListNode2<T> node, ListNode2<T> newNode) {
        newNode.next = node.next;
        newNode.prev = node;
        node.next = newNode;
        if (newNode.next == null) {
            this.head = newNode;
        } else {
            newNode.next.prev = newNode;
        }
        ++this.size;
    }

    public void addBefore(ListNode2<T> node, ListNode2<T> newNode) {
        newNode.prev = node.prev;
        newNode.next = node;
        node.prev = newNode;
        if (newNode.prev == null) {
            this.tail = newNode;
        } else {
            newNode.prev.next = newNode;
        }
        ++this.size;
    }

    public void remove(ListNode2<T> node) {
        if (node == this.tail) {
            this.tail = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node == this.head) {
            this.head = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public ListNode2<T> head() {
        return this.head;
    }

    public ListNode2<T> tail() {
        return this.tail;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

