/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.raw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.raw.RawAggregator;
import org.apache.kylin.measure.raw.RawSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMeasureType
extends MeasureType<List<ByteArray>> {
    private static final Logger logger = LoggerFactory.getLogger(RawMeasureType.class);
    public static final String FUNC_RAW = "RAW";
    public static final String DATATYPE_RAW = "raw";
    private final DataType dataType;

    public RawMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        this.validate(functionDesc.getExpression(), functionDesc.getReturnDataType(), true);
    }

    private void validate(String funcName, DataType dataType, boolean checkDataType) {
        if (!FUNC_RAW.equals(funcName)) {
            throw new IllegalArgumentException();
        }
        if (!DATATYPE_RAW.equals(dataType.getName())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<List<ByteArray>> newIngester() {
        return new MeasureIngester<List<ByteArray>>(){

            @Override
            public List<ByteArray> valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                if (values.length != 1) {
                    throw new IllegalArgumentException();
                }
                String literal = values[0];
                TblColRef literalCol = RawMeasureType.this.getRawColumn(measureDesc.getFunction());
                Dictionary<String> dictionary = dictionaryMap.get(literalCol);
                int keyEncodedValue = dictionary.getIdFromValue(literal);
                ByteArray key = new ByteArray(dictionary.getSizeOfId());
                BytesUtil.writeUnsigned(keyEncodedValue, key.array(), key.offset(), dictionary.getSizeOfId());
                ArrayList<ByteArray> valueList = new ArrayList<ByteArray>(1);
                valueList.add(key);
                return valueList;
            }

            @Override
            public List<ByteArray> reEncodeDictionary(List<ByteArray> value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                TblColRef colRef = RawMeasureType.this.getRawColumn(measureDesc.getFunction());
                Dictionary<String> sourceDict = oldDicts.get(colRef);
                Dictionary<String> mergedDict = newDicts.get(colRef);
                int valueSize = value.size();
                byte[] newIdBuf = new byte[valueSize * mergedDict.getSizeOfId()];
                byte[] literal = new byte[sourceDict.getSizeOfValue()];
                int bufOffset = 0;
                for (ByteArray c : value) {
                    int oldId = BytesUtil.readUnsigned(c.array(), c.offset(), c.length());
                    int size = sourceDict.getValueBytesFromId(oldId, literal, 0);
                    int newId = size < 0 ? mergedDict.nullId() : mergedDict.getIdFromValueBytes(literal, 0, size);
                    BytesUtil.writeUnsigned(newId, newIdBuf, bufOffset, mergedDict.getSizeOfId());
                    c.set(newIdBuf, bufOffset, mergedDict.getSizeOfId());
                    bufOffset += mergedDict.getSizeOfId();
                }
                return value;
            }
        };
    }

    @Override
    public MeasureAggregator<List<ByteArray>> newAggregator() {
        return new RawAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        TblColRef literalCol = functionDesc.getParameter().getColRefs().get(0);
        return Collections.singletonList(literalCol);
    }

    @Override
    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, MeasureDesc measureDesc) {
        if (!digest.isRawQuery()) {
            return null;
        }
        TblColRef rawColumn = this.getRawColumn(measureDesc.getFunction());
        if (!digest.allColumns.isEmpty() && !digest.allColumns.contains(rawColumn)) {
            return null;
        }
        unmatchedAggregations.remove(measureDesc.getFunction());
        return new CapabilityResult.CapabilityInfluence(){

            @Override
            public double suggestCostMultiplier() {
                return 0.9;
            }
        };
    }

    @Override
    public boolean needRewrite() {
        return false;
    }

    @Override
    public Class<?> getRewriteCalciteAggrFunctionClass() {
        return null;
    }

    @Override
    public void adjustSqlDigest(MeasureDesc measureDesc, SQLDigest sqlDigest) {
        if (sqlDigest.isRawQuery()) {
            TblColRef col = this.getRawColumn(measureDesc.getFunction());
            ParameterDesc colParameter = new ParameterDesc();
            colParameter.setType("column");
            colParameter.setValue(col.getName());
            FunctionDesc rawFunc = new FunctionDesc();
            rawFunc.setExpression(FUNC_RAW);
            rawFunc.setParameter(colParameter);
            if (sqlDigest.allColumns.contains(col)) {
                if (measureDesc.getFunction().equals(rawFunc)) {
                    FunctionDesc sumFunc = new FunctionDesc();
                    sumFunc.setExpression("SUM");
                    sumFunc.setParameter(colParameter);
                    sqlDigest.aggregations.remove(sumFunc);
                    sqlDigest.aggregations.add(rawFunc);
                    logger.info("Add RAW measure on column " + col);
                }
                if (!sqlDigest.metricColumns.contains(col)) {
                    sqlDigest.metricColumns.add(col);
                }
            }
        }
    }

    @Override
    public boolean needAdvancedTupleFilling() {
        return true;
    }

    @Override
    public void fillTupleSimply(Tuple tuple, int indexInTuple, Object measureValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MeasureType.IAdvMeasureFiller getAdvancedTupleFiller(FunctionDesc function, TupleInfo tupleInfo, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        TblColRef literalCol = this.getRawColumn(function);
        final Dictionary<String> rawColDict = dictionaryMap.get(literalCol);
        final int literalTupleIdx = tupleInfo.hasColumn(literalCol) ? tupleInfo.getColumnIndex(literalCol) : -1;
        return new MeasureType.IAdvMeasureFiller(){
            private List<ByteArray> rawList;
            private Iterator<ByteArray> rawIterator;
            private int expectRow = 0;

            @Override
            public void reload(Object measureValue) {
                this.rawList = (List)measureValue;
                this.rawIterator = this.rawList.iterator();
                this.expectRow = 0;
            }

            @Override
            public int getNumOfRows() {
                return this.rawList.size();
            }

            @Override
            public void fillTuple(Tuple tuple, int row) {
                if (this.expectRow++ != row) {
                    throw new IllegalStateException();
                }
                ByteArray raw = this.rawIterator.next();
                int key = BytesUtil.readUnsigned(raw.array(), raw.offset(), raw.length());
                String colValue = (String)rawColDict.getValueFromId(key);
                tuple.setDimensionValue(literalTupleIdx, colValue);
            }
        };
    }

    private TblColRef getRawColumn(FunctionDesc functionDesc) {
        return functionDesc.getParameter().getColRefs().get(0);
    }

    @Override
    public boolean onlyAggrInBaseCuboid() {
        return true;
    }

    public static class Factory
    extends MeasureTypeFactory<List<ByteArray>> {
        @Override
        public MeasureType<List<ByteArray>> createMeasureType(String funcName, DataType dataType) {
            return new RawMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return RawMeasureType.FUNC_RAW;
        }

        @Override
        public String getAggrDataTypeName() {
            return RawMeasureType.DATATYPE_RAW;
        }

        @Override
        public Class<? extends DataTypeSerializer<List<ByteArray>>> getAggrDataTypeSerializer() {
            return RawSerializer.class;
        }
    }
}

