/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class HLLCSerializer
extends DataTypeSerializer<HyperLogLogPlusCounter> {
    private ThreadLocal<HyperLogLogPlusCounter> current = new ThreadLocal();
    private int precision;

    public HLLCSerializer(DataType type) {
        this.precision = type.getPrecision();
    }

    @Override
    public void serialize(HyperLogLogPlusCounter value, ByteBuffer out) {
        try {
            value.writeRegisters(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HyperLogLogPlusCounter current() {
        HyperLogLogPlusCounter hllc = this.current.get();
        if (hllc == null) {
            hllc = new HyperLogLogPlusCounter(this.precision);
            this.current.set(hllc);
        }
        return hllc;
    }

    @Override
    public HyperLogLogPlusCounter deserialize(ByteBuffer in) {
        HyperLogLogPlusCounter hllc = this.current();
        try {
            hllc.readRegisters(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hllc;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return this.current().peekLength(in);
    }

    @Override
    public int maxLength() {
        return this.current().maxLength();
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.current().maxLength();
    }
}

