/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;

public class HLLCAggregator
extends MeasureAggregator<HyperLogLogPlusCounter> {
    final int precision;
    HyperLogLogPlusCounter sum = null;

    public HLLCAggregator(int precision) {
        this.precision = precision;
    }

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(HyperLogLogPlusCounter value) {
        if (this.sum == null) {
            this.sum = new HyperLogLogPlusCounter(value);
        } else {
            this.sum.merge(value);
        }
    }

    @Override
    public HyperLogLogPlusCounter getState() {
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return 60 + (1 << this.precision);
    }
}

