/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.List;
import java.util.Map;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.bitmap.BitmapAggregator;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapDistinctCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class BitmapMeasureType
extends MeasureType<BitmapCounter> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_BITMAP = "bitmap";
    public DataType dataType;

    public BitmapMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        if (!FUNC_COUNT_DISTINCT.equals(functionDesc.getExpression())) {
            throw new IllegalArgumentException("BitmapMeasureType func is not COUNT_DISTINCT but " + functionDesc.getExpression());
        }
        if (!DATATYPE_BITMAP.equals(functionDesc.getReturnDataType().getName())) {
            throw new IllegalArgumentException("BitmapMeasureType datatype is not bitmap but " + functionDesc.getReturnDataType().getName());
        }
        List<TblColRef> colRefs = functionDesc.getParameter().getColRefs();
        if (colRefs.size() != 1) {
            throw new IllegalArgumentException("BitmapMeasureType col parameters count is not 1 but " + colRefs.size());
        }
        TblColRef colRef = colRefs.get(0);
        DataType type = colRef.getType();
        if (!type.isIntegerFamily()) {
            throw new IllegalArgumentException("BitmapMeasureType col type is not IntegerFamily but " + type.getName() + " of column " + colRef.getCanonicalName());
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<BitmapCounter> newIngester() {
        return new MeasureIngester<BitmapCounter>(){
            BitmapCounter current = new BitmapCounter();

            @Override
            public BitmapCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                BitmapCounter bitmap = this.current;
                bitmap.clear();
                for (String v : values) {
                    bitmap.add(v);
                }
                return bitmap;
            }
        };
    }

    @Override
    public MeasureAggregator<BitmapCounter> newAggregator() {
        return new BitmapAggregator();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Class<?> getRewriteCalciteAggrFunctionClass() {
        return BitmapDistinctCountAggFunc.class;
    }

    public static class Factory
    extends MeasureTypeFactory<BitmapCounter> {
        @Override
        public MeasureType<BitmapCounter> createMeasureType(String funcName, DataType dataType) {
            return new BitmapMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return BitmapMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return BitmapMeasureType.DATATYPE_BITMAP;
        }

        @Override
        public Class<? extends DataTypeSerializer<BitmapCounter>> getAggrDataTypeSerializer() {
            return BitmapSerializer.class;
        }
    }
}

