/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.IllegalStateTranferException;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.DefaultOutput;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableManager {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableManager.class);
    private static final ConcurrentHashMap<KylinConfig, ExecutableManager> CACHE = new ConcurrentHashMap();
    private final KylinConfig config;
    private ExecutableDao executableDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutableManager getInstance(KylinConfig config) {
        ExecutableManager r = CACHE.get(config);
        if (r != null) return r;
        Class<ExecutableManager> clazz = ExecutableManager.class;
        synchronized (ExecutableManager.class) {
            r = CACHE.get(config);
            if (r != null) return r;
            r = new ExecutableManager(config);
            CACHE.put(config, r);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    private ExecutableManager(KylinConfig config) {
        logger.info("Using metadata url: " + config);
        this.config = config;
        this.executableDao = ExecutableDao.getInstance(config);
    }

    public void addJob(AbstractExecutable executable) {
        try {
            this.executableDao.addJob(ExecutableManager.parse(executable));
            this.addJobOutput(executable);
        }
        catch (PersistentException e) {
            logger.error("fail to submit job:" + executable.getId(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addJobOutput(AbstractExecutable executable) throws PersistentException {
        ExecutableOutputPO executableOutputPO = new ExecutableOutputPO();
        executableOutputPO.setUuid(executable.getId());
        this.executableDao.addJobOutput(executableOutputPO);
        if (executable instanceof DefaultChainedExecutable) {
            for (AbstractExecutable subTask : ((DefaultChainedExecutable)executable).getTasks()) {
                this.addJobOutput(subTask);
            }
        }
    }

    public void deleteJob(String jobId) {
        try {
            this.executableDao.deleteJob(jobId);
        }
        catch (PersistentException e) {
            logger.error("fail to delete job:" + jobId, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AbstractExecutable getJob(String uuid) {
        try {
            return ExecutableManager.parseTo(this.executableDao.getJob(uuid));
        }
        catch (PersistentException e) {
            logger.error("fail to get job:" + uuid, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Output getOutput(String uuid) {
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(uuid);
            Preconditions.checkArgument((jobOutput != null ? 1 : 0) != 0, (Object)("there is no related output for job id:" + uuid));
            return this.parseOutput(jobOutput);
        }
        catch (PersistentException e) {
            logger.error("fail to get job output:" + uuid, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private DefaultOutput parseOutput(ExecutableOutputPO jobOutput) {
        DefaultOutput result = new DefaultOutput();
        result.setExtra(jobOutput.getInfo());
        result.setState(ExecutableState.valueOf(jobOutput.getStatus()));
        result.setVerboseMsg(jobOutput.getContent());
        result.setLastModified(jobOutput.getLastModified());
        return result;
    }

    public Map<String, Output> getAllOutputs() {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs();
            HashMap result = Maps.newHashMap();
            for (ExecutableOutputPO jobOutput : jobOutputs) {
                result.put(jobOutput.getId(), this.parseOutput(jobOutput));
            }
            return result;
        }
        catch (PersistentException e) {
            logger.error("fail to get all job output:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Output> getAllOutputs(long timeStartInMillis, long timeEndInMillis) {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs(timeStartInMillis, timeEndInMillis);
            HashMap result = Maps.newHashMap();
            for (ExecutableOutputPO jobOutput : jobOutputs) {
                result.put(jobOutput.getId(), this.parseOutput(jobOutput));
            }
            return result;
        }
        catch (PersistentException e) {
            logger.error("fail to get all job output:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AbstractExecutable> getAllExecutables() {
        try {
            ArrayList ret = Lists.newArrayList();
            for (ExecutablePO po : this.executableDao.getJobs()) {
                try {
                    AbstractExecutable ae = ExecutableManager.parseTo(po);
                    ret.add(ae);
                }
                catch (IllegalArgumentException e) {
                    logger.error("error parsing one executabePO: ", (Throwable)e);
                }
            }
            return ret;
        }
        catch (PersistentException e) {
            logger.error("error get All Jobs", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<AbstractExecutable> getAllExecutables(long timeStartInMillis, long timeEndInMillis) {
        try {
            ArrayList ret = Lists.newArrayList();
            for (ExecutablePO po : this.executableDao.getJobs(timeStartInMillis, timeEndInMillis)) {
                try {
                    AbstractExecutable ae = ExecutableManager.parseTo(po);
                    ret.add(ae);
                }
                catch (IllegalArgumentException e) {
                    logger.error("error parsing one executabePO: ", (Throwable)e);
                }
            }
            return ret;
        }
        catch (PersistentException e) {
            logger.error("error get All Jobs", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllJobIds() {
        try {
            return this.executableDao.getJobIds();
        }
        catch (PersistentException e) {
            logger.error("error get All Job Ids", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void updateAllRunningJobsToError() {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs();
            for (ExecutableOutputPO executableOutputPO : jobOutputs) {
                if (!executableOutputPO.getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) continue;
                executableOutputPO.setStatus(ExecutableState.ERROR.toString());
                this.executableDao.updateJobOutput(executableOutputPO);
            }
        }
        catch (PersistentException e) {
            logger.error("error reset job status from RUNNING to ERROR", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void resumeJob(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        this.updateJobOutput(jobId, ExecutableState.READY, null, null);
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus() != ExecutableState.ERROR) continue;
                this.updateJobOutput(task.getId(), ExecutableState.READY, null, null);
                break;
            }
        }
    }

    public void discardJob(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus().isFinalState()) continue;
                this.updateJobOutput(task.getId(), ExecutableState.DISCARDED, null, null);
            }
        }
        this.updateJobOutput(jobId, ExecutableState.DISCARDED, null, null);
    }

    public void updateJobOutput(String jobId, ExecutableState newStatus, Map<String, String> info, String output) {
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(jobId);
            Preconditions.checkArgument((jobOutput != null ? 1 : 0) != 0, (Object)("there is no related output for job id:" + jobId));
            ExecutableState oldStatus = ExecutableState.valueOf(jobOutput.getStatus());
            if (newStatus != null && oldStatus != newStatus) {
                if (!ExecutableState.isValidStateTransfer(oldStatus, newStatus)) {
                    throw new IllegalStateTranferException("there is no valid state transfer from:" + (Object)((Object)oldStatus) + " to:" + (Object)((Object)newStatus));
                }
                jobOutput.setStatus(newStatus.toString());
            }
            if (info != null) {
                jobOutput.setInfo(info);
            }
            if (output != null) {
                jobOutput.setContent(output);
            }
            this.executableDao.updateJobOutput(jobOutput);
            logger.info("job id:" + jobId + " from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)newStatus));
        }
        catch (PersistentException e) {
            logger.error("error change job:" + jobId + " to " + newStatus.toString());
            throw new RuntimeException(e);
        }
    }

    public void resetJobOutput(String jobId, ExecutableState state, String output) {
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(jobId);
            jobOutput.setStatus(state.toString());
            if (output != null) {
                jobOutput.setContent(output);
            }
            this.executableDao.updateJobOutput(jobOutput);
        }
        catch (PersistentException e) {
            throw new RuntimeException(e);
        }
    }

    public void addJobInfo(String id, Map<String, String> info) {
        if (info == null) {
            return;
        }
        try {
            ExecutableOutputPO output = this.executableDao.getJobOutput(id);
            Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)("there is no related output for job id:" + id));
            output.getInfo().putAll(info);
            this.executableDao.updateJobOutput(output);
        }
        catch (PersistentException e) {
            logger.error("error update job info, id:" + id + "  info:" + info.toString());
            throw new RuntimeException(e);
        }
    }

    public void addJobInfo(String id, String key, String value) {
        HashMap info = Maps.newHashMap();
        info.put(key, value);
        this.addJobInfo(id, info);
    }

    private static ExecutablePO parse(AbstractExecutable executable) {
        ExecutablePO result = new ExecutablePO();
        result.setName(executable.getName());
        result.setUuid(executable.getId());
        result.setType(executable.getClass().getName());
        result.setParams(executable.getParams());
        if (executable instanceof ChainedExecutable) {
            ArrayList tasks = Lists.newArrayList();
            for (AbstractExecutable abstractExecutable : ((ChainedExecutable)((Object)executable)).getTasks()) {
                tasks.add(ExecutableManager.parse(abstractExecutable));
            }
            result.setTasks(tasks);
        }
        return result;
    }

    private static AbstractExecutable parseTo(ExecutablePO executablePO) {
        if (executablePO == null) {
            logger.warn("executablePO is null");
            return null;
        }
        String type = executablePO.getType();
        try {
            Class<AbstractExecutable> clazz = ClassUtil.forName(type, AbstractExecutable.class);
            Constructor<AbstractExecutable> constructor = clazz.getConstructor(new Class[0]);
            AbstractExecutable result = constructor.newInstance(new Object[0]);
            result.setId(executablePO.getUuid());
            result.setName(executablePO.getName());
            result.setParams(executablePO.getParams());
            List<ExecutablePO> tasks = executablePO.getTasks();
            if (tasks != null && !tasks.isEmpty()) {
                Preconditions.checkArgument((boolean)(result instanceof ChainedExecutable));
                for (ExecutablePO subTask : tasks) {
                    ((ChainedExecutable)((Object)result)).addTask(ExecutableManager.parseTo(subTask));
                }
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("cannot parse this job:" + executablePO.getId(), e);
        }
    }
}

