/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.MailService;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Idempotent;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.manager.ExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutable
implements Executable,
Idempotent {
    protected static final String SUBMITTER = "submitter";
    protected static final String NOTIFY_LIST = "notify_list";
    protected static final String START_TIME = "startTime";
    protected static final String END_TIME = "endTime";
    protected static final Logger logger = LoggerFactory.getLogger(AbstractExecutable.class);
    protected int retry = 0;
    private String name;
    private String id;
    private Map<String, String> params = Maps.newHashMap();
    protected static ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());

    public AbstractExecutable() {
        this.setId(UUID.randomUUID().toString());
    }

    protected void onExecuteStart(ExecutableContext executableContext) {
        HashMap info = Maps.newHashMap();
        info.put(START_TIME, Long.toString(System.currentTimeMillis()));
        executableManager.updateJobOutput(this.getId(), ExecutableState.RUNNING, info, null);
    }

    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        this.setEndTime(System.currentTimeMillis());
        if (!this.isDiscarded()) {
            if (result.succeed()) {
                executableManager.updateJobOutput(this.getId(), ExecutableState.SUCCEED, null, result.output());
            } else {
                executableManager.updateJobOutput(this.getId(), ExecutableState.ERROR, null, result.output());
            }
        }
    }

    protected void onExecuteError(Throwable exception, ExecutableContext executableContext) {
        if (!this.isDiscarded()) {
            executableManager.addJobInfo(this.getId(), END_TIME, Long.toString(System.currentTimeMillis()));
            String output = null;
            if (exception != null) {
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter(out));
                output = out.toString();
            }
            executableManager.updateJobOutput(this.getId(), ExecutableState.ERROR, null, output);
        }
    }

    @Override
    public final ExecuteResult execute(ExecutableContext executableContext) throws ExecuteException {
        Throwable exception;
        logger.info("Executing >>>>>>>>>>>>>   " + this.getName() + "   <<<<<<<<<<<<<");
        Preconditions.checkArgument((boolean)(executableContext instanceof DefaultContext));
        ExecuteResult result = null;
        this.onExecuteStart(executableContext);
        do {
            if (this.retry > 0) {
                logger.info("Retry " + this.retry);
            }
            exception = null;
            result = null;
            try {
                result = this.doWork(executableContext);
            }
            catch (Throwable e) {
                logger.error("error running Executable", e);
                exception = e;
            }
            ++this.retry;
        } while ((result != null && !result.succeed() || exception != null) && this.needRetry());
        if (exception != null) {
            this.onExecuteError(exception, executableContext);
            throw new ExecuteException(exception);
        }
        this.onExecuteFinished(result, executableContext);
        return result;
    }

    protected abstract ExecuteResult doWork(ExecutableContext var1) throws ExecuteException;

    @Override
    public void cleanup() throws ExecuteException {
    }

    @Override
    public boolean isRunnable() {
        return this.getStatus() == ExecutableState.READY;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final ExecutableState getStatus() {
        return executableManager.getOutput(this.getId()).getState();
    }

    @Override
    public final Map<String, String> getParams() {
        return this.params;
    }

    public final String getParam(String key) {
        return this.params.get(key);
    }

    public final void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public final void setParams(Map<String, String> params) {
        this.params.putAll(params);
    }

    public final long getLastModified() {
        return executableManager.getOutput(this.getId()).getLastModified();
    }

    public final void setSubmitter(String submitter) {
        this.setParam(SUBMITTER, submitter);
    }

    public final List<String> getNotifyList() {
        String str = this.getParam(NOTIFY_LIST);
        if (str != null) {
            return Lists.newArrayList((Object[])StringUtils.split((String)str, (String)","));
        }
        return Collections.emptyList();
    }

    public final void setNotifyList(String notifications) {
        this.setParam(NOTIFY_LIST, notifications);
    }

    public final void setNotifyList(List<String> notifications) {
        this.setNotifyList(StringUtils.join(notifications, (String)","));
    }

    protected Pair<String, String> formatNotifications(ExecutableContext executableContext, ExecutableState state) {
        return null;
    }

    protected final void notifyUserStatusChange(ExecutableContext context, ExecutableState state) {
        try {
            ArrayList users = Lists.newArrayList();
            users.addAll(this.getNotifyList());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            String[] adminDls = kylinConfig.getAdminDls();
            if (null != adminDls) {
                for (String adminDl : adminDls) {
                    users.add(adminDl);
                }
            }
            if (users.isEmpty()) {
                logger.warn("no need to send email, user list is empty");
                return;
            }
            Pair<String, String> email = this.formatNotifications(context, state);
            if (email == null) {
                logger.warn("no need to send email, content is null");
                return;
            }
            logger.info("prepare to send email to:" + users);
            logger.info("job name:" + this.getName());
            logger.info("submitter:" + this.getSubmitter());
            logger.info("notify list:" + users);
            new MailService(kylinConfig).sendMail(users, (String)email.getLeft(), (String)email.getRight());
        }
        catch (Exception e) {
            logger.error("error send email", (Throwable)e);
        }
    }

    public final String getSubmitter() {
        return this.getParam(SUBMITTER);
    }

    @Override
    public final Output getOutput() {
        return executableManager.getOutput(this.getId());
    }

    protected long getExtraInfoAsLong(String key, long defaultValue) {
        return AbstractExecutable.getExtraInfoAsLong(executableManager.getOutput(this.getId()), key, defaultValue);
    }

    public static long getStartTime(Output output) {
        return AbstractExecutable.getExtraInfoAsLong(output, START_TIME, 0L);
    }

    public static long getEndTime(Output output) {
        return AbstractExecutable.getExtraInfoAsLong(output, END_TIME, 0L);
    }

    public static long getDuration(long startTime, long endTime) {
        if (startTime == 0L) {
            return 0L;
        }
        if (endTime == 0L) {
            return System.currentTimeMillis() - startTime;
        }
        return endTime - startTime;
    }

    public static long getExtraInfoAsLong(Output output, String key, long defaultValue) {
        String str = output.getExtra().get(key);
        if (str != null) {
            return Long.parseLong(str);
        }
        return defaultValue;
    }

    protected final void addExtraInfo(String key, String value) {
        executableManager.addJobInfo(this.getId(), key, value);
    }

    protected final Map<String, String> getExtraInfo() {
        return executableManager.getOutput(this.getId()).getExtra();
    }

    public final void setStartTime(long time) {
        this.addExtraInfo(START_TIME, time + "");
    }

    public final void setEndTime(long time) {
        this.addExtraInfo(END_TIME, time + "");
    }

    public final long getStartTime() {
        return this.getExtraInfoAsLong(START_TIME, 0L);
    }

    public final long getEndTime() {
        return this.getExtraInfoAsLong(END_TIME, 0L);
    }

    public final long getDuration() {
        return AbstractExecutable.getDuration(this.getStartTime(), this.getEndTime());
    }

    protected final boolean isDiscarded() {
        ExecutableState status = executableManager.getOutput(this.getId()).getState();
        return status == ExecutableState.DISCARDED;
    }

    protected boolean needRetry() {
        return this.retry <= KylinConfig.getInstanceFromEnv().getJobRetry();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("state", (Object)this.getStatus()).toString();
    }
}

