/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;

public class ShellExecutable
extends AbstractExecutable {
    private static final String CMD = "cmd";

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        try {
            logger.info("executing:" + this.getCmd());
            ShellExecutableLogger logger = new ShellExecutableLogger();
            Pair<Integer, String> result = context.getConfig().getCliCommandExecutor().execute(this.getCmd(), logger);
            executableManager.addJobInfo(this.getId(), logger.getInfo());
            return new ExecuteResult(result.getFirst() == 0 ? ExecuteResult.State.SUCCEED : ExecuteResult.State.FAILED, result.getSecond());
        }
        catch (IOException e) {
            logger.error("job:" + this.getId() + " execute finished with exception", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    public void setCmd(String cmd) {
        this.setParam(CMD, cmd);
    }

    public String getCmd() {
        return this.getParam(CMD);
    }

    private static class ShellExecutableLogger
    implements Logger {
        private final Map<String, String> info = Maps.newHashMap();
        private static final Pattern PATTERN_APP_ID = Pattern.compile("Submitted application (.*?) to ResourceManager");
        private static final Pattern PATTERN_APP_URL = Pattern.compile("The url to track the job: (.*)");
        private static final Pattern PATTERN_JOB_ID = Pattern.compile("Running job: (.*)");
        private static final Pattern PATTERN_HDFS_BYTES_WRITTEN = Pattern.compile("(?:HD|MAPR)FS: Number of bytes written=(\\d+)");
        private static final Pattern PATTERN_SOURCE_RECORDS_COUNT = Pattern.compile("Map input records=(\\d+)");
        private static final Pattern PATTERN_SOURCE_RECORDS_SIZE = Pattern.compile("(?:HD|MAPR)FS Read: (\\d+) HDFS Write");
        private static final Pattern PATTERN_HIVE_APP_ID_URL = Pattern.compile("Starting Job = (.*?), Tracking URL = (.*)");
        private static final Pattern PATTERN_HIVE_BYTES_WRITTEN = Pattern.compile("(?:HD|MAPR)FS Read: (\\d+) HDFS Write: (\\d+) SUCCESS");

        private ShellExecutableLogger() {
        }

        @Override
        public void log(String message) {
            String hdfsWritten;
            Matcher matcher = PATTERN_APP_ID.matcher(message);
            if (matcher.find()) {
                String appId = matcher.group(1);
                this.info.put("yarn_application_id", appId);
            }
            if ((matcher = PATTERN_APP_URL.matcher(message)).find()) {
                String appTrackingUrl = matcher.group(1);
                this.info.put("yarn_application_tracking_url", appTrackingUrl);
            }
            if ((matcher = PATTERN_JOB_ID.matcher(message)).find()) {
                String mrJobID = matcher.group(1);
                this.info.put("mr_job_id", mrJobID);
            }
            if ((matcher = PATTERN_HDFS_BYTES_WRITTEN.matcher(message)).find()) {
                hdfsWritten = matcher.group(1);
                this.info.put("hdfs_bytes_written", hdfsWritten);
            }
            if ((matcher = PATTERN_SOURCE_RECORDS_COUNT.matcher(message)).find()) {
                String sourceCount = matcher.group(1);
                this.info.put("source_records_count", sourceCount);
            }
            if ((matcher = PATTERN_SOURCE_RECORDS_SIZE.matcher(message)).find()) {
                String sourceSize = matcher.group(1);
                this.info.put("source_records_size", sourceSize);
            }
            if ((matcher = PATTERN_HIVE_APP_ID_URL.matcher(message)).find()) {
                String jobId = matcher.group(1);
                String trackingUrl = matcher.group(2);
                this.info.put("mr_job_id", jobId);
                this.info.put("yarn_application_tracking_url", trackingUrl);
            }
            if ((matcher = PATTERN_HIVE_BYTES_WRITTEN.matcher(message)).find()) {
                hdfsWritten = matcher.group(2);
                this.info.put("hdfs_bytes_written", hdfsWritten);
            }
        }

        Map<String, String> getInfo() {
            return this.info;
        }
    }
}

