/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.IntermediateColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JoinedFlatTable {
    public static String getTableDir(IJoinedFlatTableDesc intermediateTableDesc, String storageDfsDir) {
        return storageDfsDir + "/" + intermediateTableDesc.getTableName();
    }

    public static String generateHiveSetStatements(JobEngineConfig engineConfig) throws IOException {
        StringBuilder buffer = new StringBuilder();
        File hadoopPropertiesFile = new File(engineConfig.getHiveConfFilePath());
        if (hadoopPropertiesFile.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(hadoopPropertiesFile);
                NodeList nl = doc.getElementsByTagName("property");
                for (int i = 0; i < nl.getLength(); ++i) {
                    String name = doc.getElementsByTagName("name").item(i).getFirstChild().getNodeValue();
                    String value = doc.getElementsByTagName("value").item(i).getFirstChild().getNodeValue();
                    if (name.equals("tmpjars")) continue;
                    buffer.append("SET " + name + "=" + value + ";\n");
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }
        return buffer.toString();
    }

    public static String generateCreateTableStatement(IJoinedFlatTableDesc intermediateTableDesc, String storageDfsDir) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE EXTERNAL TABLE IF NOT EXISTS " + intermediateTableDesc.getTableName() + "\n");
        ddl.append("(\n");
        for (int i = 0; i < intermediateTableDesc.getColumnList().size(); ++i) {
            IntermediateColumnDesc col = intermediateTableDesc.getColumnList().get(i);
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(JoinedFlatTable.colName(col.getCanonicalName()) + " " + JoinedFlatTable.getHiveDataType(col.getDataType()) + "\n");
        }
        ddl.append(")\n");
        ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\177'\n");
        ddl.append("STORED AS SEQUENCEFILE\n");
        ddl.append("LOCATION '" + JoinedFlatTable.getTableDir(intermediateTableDesc, storageDfsDir) + "';").append("\n");
        return ddl.toString();
    }

    public static String generateDropTableStatement(IJoinedFlatTableDesc intermediateTableDesc) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("DROP TABLE IF EXISTS " + intermediateTableDesc.getTableName() + ";").append("\n");
        return ddl.toString();
    }

    public static String generateInsertDataStatement(IJoinedFlatTableDesc intermediateTableDesc, JobEngineConfig engineConfig) throws IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT OVERWRITE TABLE " + intermediateTableDesc.getTableName() + " " + JoinedFlatTable.generateSelectDataStatement(intermediateTableDesc) + ";").append("\n");
        return sql.toString();
    }

    public static String generateSelectDataStatement(IJoinedFlatTableDesc intermediateTableDesc) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT\n");
        Map<String, String> tableAliasMap = JoinedFlatTable.buildTableAliasMap(intermediateTableDesc.getDataModel());
        for (int i = 0; i < intermediateTableDesc.getColumnList().size(); ++i) {
            IntermediateColumnDesc col = intermediateTableDesc.getColumnList().get(i);
            if (i > 0) {
                sql.append(",");
            }
            String tableAlias = tableAliasMap.get(col.getTableName());
            sql.append(tableAlias + "." + col.getColumnName() + "\n");
        }
        JoinedFlatTable.appendJoinStatement(intermediateTableDesc, sql, tableAliasMap);
        JoinedFlatTable.appendWhereStatement(intermediateTableDesc, sql, tableAliasMap);
        return sql.toString();
    }

    private static Map<String, String> buildTableAliasMap(DataModelDesc dataModelDesc) {
        HashMap<String, String> tableAliasMap = new HashMap<String, String>();
        JoinedFlatTable.addTableAlias(dataModelDesc.getFactTable(), tableAliasMap);
        for (LookupDesc lookupDesc : dataModelDesc.getLookups()) {
            JoinDesc join = lookupDesc.getJoin();
            if (join == null) continue;
            JoinedFlatTable.addTableAlias(lookupDesc.getTable(), tableAliasMap);
        }
        return tableAliasMap;
    }

    private static void addTableAlias(String table, Map<String, String> tableAliasMap) {
        int cut = table.lastIndexOf(46);
        String alias = cut < 0 ? table : table.substring(cut + 1);
        tableAliasMap.put(table, alias);
    }

    private static void appendJoinStatement(IJoinedFlatTableDesc intermediateTableDesc, StringBuilder sql, Map<String, String> tableAliasMap) {
        HashSet<String> dimTableCache = new HashSet<String>();
        DataModelDesc dataModelDesc = intermediateTableDesc.getDataModel();
        String factTableName = dataModelDesc.getFactTable();
        String factTableAlias = tableAliasMap.get(factTableName);
        sql.append("FROM " + factTableName + " as " + factTableAlias + " \n");
        for (LookupDesc lookupDesc : dataModelDesc.getLookups()) {
            TblColRef[] fk;
            JoinDesc join = lookupDesc.getJoin();
            if (join == null || join.getType().equals("")) continue;
            String joinType = join.getType().toUpperCase();
            String dimTableName = lookupDesc.getTable();
            if (dimTableCache.contains(dimTableName)) continue;
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new RuntimeException("Invalid join condition of lookup table:" + lookupDesc);
            }
            sql.append(joinType + " JOIN " + dimTableName + " as " + tableAliasMap.get(dimTableName) + "\n");
            sql.append("ON ");
            for (int i = 0; i < pk.length; ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(factTableAlias + "." + fk[i].getName() + " = " + tableAliasMap.get(dimTableName) + "." + pk[i].getName());
            }
            sql.append("\n");
            dimTableCache.add(dimTableName);
        }
    }

    private static void appendWhereStatement(IJoinedFlatTableDesc intermediateTableDesc, StringBuilder sql, Map<String, String> tableAliasMap) {
        CubeSegment cubeSegment;
        if (!(intermediateTableDesc instanceof CubeJoinedFlatTableDesc)) {
            return;
        }
        CubeJoinedFlatTableDesc desc = (CubeJoinedFlatTableDesc)intermediateTableDesc;
        boolean hasCondition = false;
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append("WHERE");
        CubeDesc cubeDesc = desc.getCubeDesc();
        DataModelDesc model = cubeDesc.getModel();
        if (model.getFilterCondition() != null && !model.getFilterCondition().equals("")) {
            whereBuilder.append(" (").append(model.getFilterCondition()).append(") ");
            hasCondition = true;
        }
        if (null != (cubeSegment = desc.getCubeSegment())) {
            PartitionDesc partDesc = model.getPartitionDesc();
            long dateStart = cubeSegment.getDateRangeStart();
            long dateEnd = cubeSegment.getDateRangeEnd();
            if (dateStart != 0L || dateEnd != Long.MAX_VALUE) {
                whereBuilder.append(hasCondition ? " AND (" : " (");
                whereBuilder.append(partDesc.getPartitionConditionBuilder().buildDateRangeCondition(partDesc, dateStart, dateEnd, tableAliasMap));
                whereBuilder.append(")\n");
                hasCondition = true;
            }
        }
        if (hasCondition) {
            sql.append(whereBuilder.toString());
        }
    }

    private static String colName(String canonicalColName) {
        return canonicalColName.replace(".", "_");
    }

    private static String getHiveDataType(String javaDataType) {
        String hiveDataType = javaDataType.toLowerCase().startsWith("varchar") ? "string" : javaDataType;
        hiveDataType = javaDataType.toLowerCase().startsWith("integer") ? "int" : hiveDataType;
        return hiveDataType.toLowerCase();
    }
}

