/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepCmdTypeEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.engine.JobEngineConfig;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JobInstance
extends RootPersistentEntity
implements Comparable<JobInstance> {
    public static final String JOB_WORKING_DIR_PREFIX = "kylin-";
    public static final String YARN_APP_ID = "yarn_application_id";
    public static final String YARN_APP_URL = "yarn_application_tracking_url";
    public static final String MR_JOB_ID = "mr_job_id";
    public static final String HDFS_BYTES_WRITTEN = "hdfs_bytes_written";
    public static final String SOURCE_RECORDS_COUNT = "source_records_count";
    public static final String SOURCE_RECORDS_SIZE = "source_records_size";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private CubeBuildTypeEnum type;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="related_cube")
    private String relatedCube;
    @JsonProperty(value="related_segment")
    private String relatedSegment;
    @JsonProperty(value="exec_start_time")
    private long execStartTime;
    @JsonProperty(value="exec_end_time")
    private long execEndTime;
    @JsonProperty(value="mr_waiting")
    private long mrWaiting = 0L;
    @JsonManagedReference
    @JsonProperty(value="steps")
    private List<JobStep> steps;
    @JsonProperty(value="submitter")
    private String submitter;
    @JsonProperty(value="job_status")
    private JobStatusEnum status;

    public static String getStepIdentity(JobInstance jobInstance, JobStep jobStep) {
        return jobInstance.getRelatedCube() + "." + jobInstance.getUuid() + "." + jobStep.getSequenceID();
    }

    public static String getJobIdentity(JobInstance jobInstance) {
        return jobInstance.getRelatedCube() + "." + jobInstance.getUuid();
    }

    public static String getJobWorkingDir(JobInstance jobInstance, JobEngineConfig engineConfig) {
        return JobInstance.getJobWorkingDir(jobInstance.getUuid(), engineConfig.getHdfsWorkingDirectory());
    }

    public static String getJobWorkingDir(String jobUuid, String hdfsWorkdingDir) {
        if (jobUuid == null || jobUuid.equals("")) {
            throw new IllegalArgumentException("jobUuid can't be null or empty");
        }
        return hdfsWorkdingDir + JOB_WORKING_DIR_PREFIX + jobUuid;
    }

    public JobStep getRunningStep() {
        for (JobStep step : this.getSteps()) {
            if (!step.getStatus().equals((Object)JobStepStatusEnum.RUNNING) && !step.getStatus().equals((Object)JobStepStatusEnum.WAITING)) continue;
            return step;
        }
        return null;
    }

    @JsonProperty(value="progress")
    public double getProgress() {
        int completedStepCount = 0;
        for (JobStep step : this.getSteps()) {
            if (!step.getStatus().equals((Object)JobStepStatusEnum.FINISHED)) continue;
            ++completedStepCount;
        }
        return 100.0 * (double)completedStepCount / (double)this.steps.size();
    }

    public JobStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(JobStatusEnum status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CubeBuildTypeEnum getType() {
        return this.type;
    }

    public void setType(CubeBuildTypeEnum type) {
        this.type = type;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getRelatedCube() {
        return this.relatedCube;
    }

    public void setRelatedCube(String relatedCube) {
        this.relatedCube = relatedCube;
    }

    public String getRelatedSegment() {
        return this.relatedSegment;
    }

    public void setRelatedSegment(String relatedSegment) {
        this.relatedSegment = relatedSegment;
    }

    public long getExecStartTime() {
        return this.execStartTime;
    }

    public void setExecStartTime(long execStartTime) {
        this.execStartTime = execStartTime;
    }

    public long getExecEndTime() {
        return this.execEndTime;
    }

    public void setExecEndTime(long execEndTime) {
        this.execEndTime = execEndTime;
    }

    public long getMrWaiting() {
        return this.mrWaiting;
    }

    public void setMrWaiting(long mrWaiting) {
        this.mrWaiting = mrWaiting;
    }

    public List<JobStep> getSteps() {
        if (this.steps == null) {
            this.steps = Lists.newArrayList();
        }
        return this.steps;
    }

    public void clearSteps() {
        this.getSteps().clear();
    }

    public void addSteps(Collection<JobStep> steps) {
        this.getSteps().addAll(steps);
    }

    public void addStep(JobStep step) {
        this.getSteps().add(step);
    }

    public void addStep(int index, JobStep step) {
        this.getSteps().add(index, step);
    }

    public JobStep findStep(String stepName) {
        for (JobStep step : this.getSteps()) {
            if (!stepName.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    @Override
    public int compareTo(JobInstance o) {
        return o.lastModified < this.lastModified ? -1 : (o.lastModified > this.lastModified ? 1 : 0);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JobStep
    implements Comparable<JobStep> {
        @JsonBackReference
        private JobInstance jobInstance;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="sequence_id")
        private int sequenceID;
        @JsonProperty(value="exec_cmd")
        private String execCmd;
        @JsonProperty(value="interrupt_cmd")
        private String InterruptCmd;
        @JsonProperty(value="exec_start_time")
        private long execStartTime;
        @JsonProperty(value="exec_end_time")
        private long execEndTime;
        @JsonProperty(value="exec_wait_time")
        private long execWaitTime;
        @JsonProperty(value="step_status")
        private JobStepStatusEnum status;
        @JsonProperty(value="cmd_type")
        private JobStepCmdTypeEnum cmdType = JobStepCmdTypeEnum.SHELL_CMD_HADOOP;
        @JsonProperty(value="info")
        private ConcurrentHashMap<String, String> info = new ConcurrentHashMap();
        @JsonProperty(value="run_async")
        private boolean runAsync = false;

        private ConcurrentHashMap<String, String> getInfo() {
            return this.info;
        }

        public void putInfo(String key, String value) {
            this.getInfo().put(key, value);
        }

        public String getInfo(String key) {
            return this.getInfo().get(key);
        }

        public void clearInfo() {
            this.getInfo().clear();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSequenceID() {
            return this.sequenceID;
        }

        public void setSequenceID(int sequenceID) {
            this.sequenceID = sequenceID;
        }

        public String getExecCmd() {
            return this.execCmd;
        }

        public void setExecCmd(String execCmd) {
            this.execCmd = execCmd;
        }

        public JobStepStatusEnum getStatus() {
            return this.status;
        }

        public void setStatus(JobStepStatusEnum status) {
            this.status = status;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getExecStartTime() {
            return this.execStartTime;
        }

        public void setExecStartTime(long execStartTime) {
            this.execStartTime = execStartTime;
        }

        public long getExecEndTime() {
            return this.execEndTime;
        }

        public void setExecEndTime(long execEndTime) {
            this.execEndTime = execEndTime;
        }

        public long getExecWaitTime() {
            return this.execWaitTime;
        }

        public void setExecWaitTime(long execWaitTime) {
            this.execWaitTime = execWaitTime;
        }

        public String getInterruptCmd() {
            return this.InterruptCmd;
        }

        public void setInterruptCmd(String interruptCmd) {
            this.InterruptCmd = interruptCmd;
        }

        public JobStepCmdTypeEnum getCmdType() {
            return this.cmdType;
        }

        public void setCmdType(JobStepCmdTypeEnum cmdType) {
            this.cmdType = cmdType;
        }

        public boolean isRunAsync() {
            return this.runAsync;
        }

        public void setRunAsync(boolean runAsync) {
            this.runAsync = runAsync;
        }

        public JobInstance getJobInstance() {
            return this.jobInstance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.sequenceID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobStep other = (JobStep)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.sequenceID == other.sequenceID;
        }

        @Override
        public int compareTo(JobStep o) {
            if (this.sequenceID < o.sequenceID) {
                return -1;
            }
            if (this.sequenceID > o.sequenceID) {
                return 1;
            }
            return 0;
        }
    }
}

