/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.IterableDictionaryValueEnumerator;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.metadata.model.TblColRef;

public final class IIDictionaryBuilder {
    private IIDictionaryBuilder() {
    }

    public static Dictionary<?>[] buildDictionary(List<List<String>> table, IIDesc desc) throws IOException {
        HashMultimap valueMap = HashMultimap.create();
        List<TblColRef> allColumns = desc.listAllColumns();
        for (List<String> row : table) {
            for (int i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                if (desc.isMetricsCol(i)) continue;
                valueMap.put((Object)allColumns.get(i), (Object)cell);
            }
        }
        Dictionary[] result = new Dictionary[allColumns.size()];
        for (TblColRef tblColRef : valueMap.keySet()) {
            Dictionary<String> dict;
            Collection bytes = Collections2.transform((Collection)valueMap.get((Object)tblColRef), (Function)new Function<String, byte[]>(){

                @Nullable
                public byte[] apply(String input) {
                    return input == null ? null : input.getBytes();
                }
            });
            result[desc.findColumn((TblColRef)tblColRef)] = dict = DictionaryGenerator.buildDictionaryFromValueEnumerator(tblColRef.getType(), new IterableDictionaryValueEnumerator(bytes));
        }
        return result;
    }
}

