/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.invertedindex.model.IIDesc;

public final class IIRow {
    private final ImmutableBytesWritable key;
    private final ImmutableBytesWritable value;
    private final ImmutableBytesWritable dictionary;

    public IIRow(ImmutableBytesWritable key, ImmutableBytesWritable value, ImmutableBytesWritable dictionary) {
        this.key = key;
        this.value = value;
        this.dictionary = dictionary;
    }

    public IIRow() {
        this(new ImmutableBytesWritable(), new ImmutableBytesWritable(), new ImmutableBytesWritable());
    }

    public ImmutableBytesWritable getKey() {
        return this.key;
    }

    public ImmutableBytesWritable getValue() {
        return this.value;
    }

    public ImmutableBytesWritable getDictionary() {
        return this.dictionary;
    }

    public void updateWith(Cell c) {
        if (BytesUtil.compareBytes(IIDesc.HBASE_QUALIFIER_BYTES, 0, c.getQualifierArray(), c.getQualifierOffset(), IIDesc.HBASE_QUALIFIER_BYTES.length) == 0) {
            this.getKey().set(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength());
            this.getValue().set(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        } else if (BytesUtil.compareBytes(IIDesc.HBASE_DICTIONARY_BYTES, 0, c.getQualifierArray(), c.getQualifierOffset(), IIDesc.HBASE_DICTIONARY_BYTES.length) == 0) {
            this.getDictionary().set(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        }
    }

    public List<Cell> makeCells() {
        KeyValue a = new KeyValue(this.getKey().copyBytes(), IIDesc.HBASE_FAMILY_BYTES, IIDesc.HBASE_QUALIFIER_BYTES, this.getValue().copyBytes());
        KeyValue b = new KeyValue(this.getKey().copyBytes(), IIDesc.HBASE_FAMILY_BYTES, IIDesc.HBASE_DICTIONARY_BYTES, this.getDictionary().copyBytes());
        return Lists.newArrayList((Object[])new Cell[]{a, b});
    }
}

