/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.kylin.common.util.FIFOIterable;
import org.apache.kylin.common.util.FIFOIterator;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.model.IIKeyValueCodec;
import org.apache.kylin.invertedindex.model.IIRow;

public class IIKeyValueCodecWithState
extends IIKeyValueCodec {
    public IIKeyValueCodecWithState(TableRecordInfoDigest digest) {
        super(digest);
    }

    @Override
    public Iterable<Slice> decodeKeyValue(Iterable<IIRow> kvs) {
        if (!(kvs instanceof FIFOIterable)) {
            throw new IllegalArgumentException("kvs must be a {@link org.apache.kylin.common.util.FIFOIterable } to avoid {@link java.util.ConcurrentModificationException}.");
        }
        return new IIRowDecoderWithState(this.digest, kvs.iterator());
    }

    protected static class IIRowDecoderWithState
    extends IIKeyValueCodec.IIRowDecoder {
        final LinkedList<IIRow> buffer = Lists.newLinkedList();
        private Iterator<Slice> superIterator = null;

        private IIRowDecoderWithState(TableRecordInfoDigest digest, Iterator<IIRow> iiRowIterator) {
            super(digest, iiRowIterator);
            this.feedingIterator = new FIFOIterator<IIRow>(this.buffer);
        }

        private Iterator<Slice> getSuperIterator() {
            if (this.superIterator == null) {
                this.superIterator = super.iterator();
            }
            return this.superIterator;
        }

        @Override
        public Iterator<Slice> iterator() {
            return new Iterator<Slice>(){

                @Override
                public boolean hasNext() {
                    while (IIRowDecoderWithState.this.buffer.size() < IIRowDecoderWithState.this.incompleteDigest.getColumnCount() && IIRowDecoderWithState.this.iiRowIterator.hasNext()) {
                        IIRowDecoderWithState.this.buffer.add((IIRow)IIRowDecoderWithState.this.iiRowIterator.next());
                    }
                    return IIRowDecoderWithState.this.buffer.size() == IIRowDecoderWithState.this.incompleteDigest.getColumnCount();
                }

                @Override
                public Slice next() {
                    while (IIRowDecoderWithState.this.buffer.size() < IIRowDecoderWithState.this.incompleteDigest.getColumnCount() && IIRowDecoderWithState.this.iiRowIterator.hasNext()) {
                        IIRowDecoderWithState.this.buffer.add((IIRow)IIRowDecoderWithState.this.iiRowIterator.next());
                    }
                    Preconditions.checkArgument((IIRowDecoderWithState.this.buffer.size() == IIRowDecoderWithState.this.incompleteDigest.getColumnCount() ? 1 : 0) != 0, (Object)"not enough IIRows!");
                    Slice ret = (Slice)IIRowDecoderWithState.this.getSuperIterator().next();
                    IIRowDecoderWithState.this.buffer.clear();
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

