/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.index.ColumnValueContainer;
import org.apache.kylin.invertedindex.index.CompressedValueContainer;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.invertedindex.model.IIRow;
import org.apache.kylin.invertedindex.model.KeyValueCodec;
import org.apache.kylin.metadata.datatype.DataType;

public class IIKeyValueCodec
implements KeyValueCodec {
    public static final int SHARD_LEN = 2;
    public static final int TIMEPART_LEN = 8;
    public static final int COLNO_LEN = 2;
    protected final TableRecordInfoDigest digest;

    public IIKeyValueCodec(TableRecordInfoDigest digest) {
        this.digest = digest;
    }

    @Override
    public Collection<IIRow> encodeKeyValue(Slice slice) {
        ArrayList result = Lists.newArrayList();
        ColumnValueContainer[] containers = slice.getColumnValueContainers();
        for (int col = 0; col < containers.length; ++col) {
            if (!(containers[col] instanceof CompressedValueContainer)) {
                throw new IllegalArgumentException("Unknown container class " + containers[col].getClass());
            }
            IIRow row = this.collectKeyValues(slice, col, (CompressedValueContainer)containers[col]);
            result.add(row);
        }
        return result;
    }

    private IIRow collectKeyValues(Slice slice, int col, CompressedValueContainer container) {
        Dictionary<?> dictionary;
        ImmutableBytesWritable key = this.encodeKey(slice.getShard(), slice.getTimestamp(), col);
        ImmutableBytesWritable value = container.toBytes();
        Dictionary<?> dictionary2 = dictionary = slice.getLocalDictionaries() != null ? slice.getLocalDictionaries()[col] : null;
        if (dictionary == null) {
            return new IIRow(key, value, new ImmutableBytesWritable(BytesUtil.EMPTY_BYTE_ARRAY));
        }
        ByteArray bytes = DictionarySerializer.serialize(dictionary);
        return new IIRow(key, value, new ImmutableBytesWritable(bytes.array(), bytes.offset(), bytes.length()));
    }

    ImmutableBytesWritable encodeKey(short shard, long timestamp, int col) {
        byte[] bytes = new byte[20];
        int len = this.encodeKey(shard, timestamp, col, bytes, 0);
        return new ImmutableBytesWritable(bytes, 0, len);
    }

    int encodeKey(short shard, long timestamp, int col, byte[] buf, int offset) {
        int i = offset;
        BytesUtil.writeUnsigned(shard, buf, i, 2);
        BytesUtil.writeLong(timestamp, buf, i += 2, 8);
        BytesUtil.writeUnsigned(col, buf, i += 8, 2);
        return (i += 2) - offset;
    }

    @Override
    public Iterable<Slice> decodeKeyValue(Iterable<IIRow> kvs) {
        return new IIRowDecoder(this.digest, kvs.iterator());
    }

    private static TableRecordInfoDigest createDigest(int nColumns, boolean[] isMetric, String[] dataTypes, Dictionary<?>[] dictionaries) {
        int[] dictMaxIds = new int[nColumns];
        int[] lengths = new int[nColumns];
        boolean emptyDictionary = Array.isEmpty(dictionaries);
        for (int i = 0; i < nColumns; ++i) {
            if (isMetric[i]) {
                FixedLenMeasureCodec<?> fixedLenMeasureCodec = FixedLenMeasureCodec.get(DataType.getType(dataTypes[i]));
                lengths[i] = fixedLenMeasureCodec.getLength();
                continue;
            }
            if (emptyDictionary) {
                DataType dataType = DataType.getType(dataTypes[i]);
                if (dataType.isNumberFamily()) {
                    lengths[i] = 16;
                } else if (dataType.isStringFamily()) {
                    lengths[i] = 256;
                } else if (dataType.isDateTimeFamily()) {
                    lengths[i] = 19;
                } else {
                    throw new RuntimeException("invalid data type:" + dataType);
                }
                dictMaxIds[i] = Integer.MAX_VALUE;
                continue;
            }
            Dictionary<?> dictionary = dictionaries[i];
            lengths[i] = dictionary.getSizeOfId();
            dictMaxIds[i] = dictionary.getMaxId();
        }
        int pos = 0;
        int[] offsets = new int[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            offsets[i] = pos;
            pos += lengths[i];
        }
        int byteFormLen = pos;
        return new TableRecordInfoDigest(nColumns, byteFormLen, offsets, dictMaxIds, lengths, isMetric, dataTypes);
    }

    protected static class IIRowDecoder
    implements Iterable<Slice> {
        protected final TableRecordInfoDigest incompleteDigest;
        protected final Iterator<IIRow> iiRowIterator;
        protected Iterator<IIRow> feedingIterator;

        protected IIRowDecoder(TableRecordInfoDigest digest, Iterator<IIRow> iiRowIterator) {
            this.incompleteDigest = digest;
            this.iiRowIterator = iiRowIterator;
            this.feedingIterator = this.iiRowIterator;
        }

        @Override
        public Iterator<Slice> iterator() {
            return new Iterator<Slice>(){

                @Override
                public boolean hasNext() {
                    return IIRowDecoder.this.iiRowIterator.hasNext();
                }

                @Override
                public Slice next() {
                    int columns;
                    ColumnValueContainer[] valueContainers = new ColumnValueContainer[IIRowDecoder.this.incompleteDigest.getColumnCount()];
                    Dictionary[] localDictionaries = new Dictionary[IIRowDecoder.this.incompleteDigest.getColumnCount()];
                    boolean firstTime = true;
                    short curShard = 0;
                    long curTimestamp = 0L;
                    short lastShard = 0;
                    long lastTimestamp = 0L;
                    for (columns = 0; IIRowDecoder.this.feedingIterator.hasNext() && columns < IIRowDecoder.this.incompleteDigest.getColumnCount(); ++columns) {
                        int curCol;
                        IIRow row = IIRowDecoder.this.feedingIterator.next();
                        ImmutableBytesWritable key = row.getKey();
                        int i = key.getOffset();
                        curShard = (short)BytesUtil.readUnsigned(key.get(), i, 2);
                        curTimestamp = BytesUtil.readLong(key.get(), i += 2, 8);
                        i += 8;
                        if (!firstTime) {
                            Preconditions.checkArgument((curShard == lastShard ? 1 : 0) != 0, (Object)("shard should be equals in one slice, curShard is" + curShard + " lastShard is " + lastShard));
                            Preconditions.checkArgument((curTimestamp == lastTimestamp ? 1 : 0) != 0, (Object)("timestamp should be equals in one slice, curTimestamp is" + curTimestamp + " lastTimestamp is " + lastTimestamp));
                        }
                        if (IIRowDecoder.this.incompleteDigest.isMetrics(curCol = BytesUtil.readUnsigned(key.get(), i, 2))) {
                            CompressedValueContainer c = new CompressedValueContainer(IIRowDecoder.this.incompleteDigest, curCol, 0);
                            c.fromBytes(row.getValue());
                            valueContainers[curCol] = c;
                        } else {
                            ImmutableBytesWritable dictBytes = row.getDictionary();
                            if (dictBytes.getLength() != 0) {
                                Dictionary<?> dictionary = DictionarySerializer.deserialize(new ByteArray(dictBytes.get(), dictBytes.getOffset(), dictBytes.getLength()));
                                CompressedValueContainer c = new CompressedValueContainer(dictionary.getSizeOfId(), dictionary.getMaxId() - dictionary.getMinId() + 1, 0);
                                c.fromBytes(row.getValue());
                                valueContainers[curCol] = c;
                                localDictionaries[curCol] = dictionary;
                            } else {
                                CompressedValueContainer c = new CompressedValueContainer(IIRowDecoder.this.incompleteDigest.length(curCol), IIRowDecoder.this.incompleteDigest.getMaxID(curCol) - 0 + 1, 0);
                                c.fromBytes(row.getValue());
                                valueContainers[curCol] = c;
                            }
                        }
                        lastShard = curShard;
                        lastTimestamp = curTimestamp;
                        firstTime = false;
                    }
                    Preconditions.checkArgument((columns == IIRowDecoder.this.incompleteDigest.getColumnCount() ? 1 : 0) != 0, (Object)("column count is " + columns + " should be equals to incompleteDigest.getColumnCount() " + IIRowDecoder.this.incompleteDigest.getColumnCount()));
                    TableRecordInfoDigest digest = IIKeyValueCodec.createDigest(columns, IIRowDecoder.this.incompleteDigest.getIsMetric(), IIRowDecoder.this.incompleteDigest.getMetricDataTypes(), localDictionaries);
                    Slice slice = new Slice(digest, curShard, curTimestamp, valueContainers);
                    slice.setLocalDictionaries(localDictionaries);
                    return slice;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

