/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.net.util.Base64;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class IIDesc
extends RootPersistentEntity {
    public static final String HBASE_FAMILY = "f";
    public static final String HBASE_QUALIFIER = "c";
    public static final String HBASE_DICTIONARY = "d";
    public static final byte[] HBASE_FAMILY_BYTES = Bytes.toBytes("f");
    public static final byte[] HBASE_QUALIFIER_BYTES = Bytes.toBytes("c");
    public static final byte[] HBASE_DICTIONARY_BYTES = Bytes.toBytes("d");
    private KylinConfig config;
    private DataModelDesc model;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="model_name")
    private String modelName;
    @JsonProperty(value="timestamp_dimension")
    private String timestampDimension;
    @JsonProperty(value="bitmap_dimensions")
    private List<ModelDimensionDesc> bitmapDimensions = Collections.emptyList();
    @JsonProperty(value="value_dimensions")
    private List<ModelDimensionDesc> valueDimensions;
    @JsonProperty(value="metrics")
    private String[] metricNames;
    @JsonProperty(value="sharding")
    private short sharding = 1;
    @JsonProperty(value="slice_size")
    private int sliceSize = 50000;
    @JsonProperty(value="engine_type")
    private int engineType = 3;
    @JsonProperty(value="storage_type")
    private int storageType = 0;
    @JsonProperty(value="signature")
    private String signature;
    private List<TableDesc> allTables = Lists.newArrayList();
    private List<TblColRef> allColumns = Lists.newArrayList();
    private List<TblColRef> allDimensions = Lists.newArrayList();
    private int tsCol;
    private int[] bitmapCols;
    private int[] valueCols;
    private int[] metricsCols;
    private BitSet metricsColSet;
    private List<MeasureDesc> measureDescs;

    public void init(MetadataManager metadataManager) {
        int i;
        this.config = metadataManager.getConfig();
        if (this.modelName == null || this.modelName.length() == 0) {
            throw new RuntimeException("The cubeDesc '" + this.getName() + "' doesn't have data model specified.");
        }
        this.model = MetadataManager.getInstance(this.config).getDataModelDesc(this.modelName);
        if (this.model == null) {
            throw new RuntimeException("No data model found with name '" + this.modelName + "'.");
        }
        this.timestampDimension = this.timestampDimension.toUpperCase();
        ModelDimensionDesc.capicalizeStrings(this.bitmapDimensions);
        ModelDimensionDesc.capicalizeStrings(this.valueDimensions);
        StringUtil.toUpperCaseArray(this.metricNames, this.metricNames);
        HashSet allTableNames = Sets.newHashSet();
        this.measureDescs = Lists.newArrayList();
        this.measureDescs.add(this.makeCountMeasure());
        for (ModelDimensionDesc modelDimensionDesc : Iterables.concat(this.bitmapDimensions, this.valueDimensions)) {
            TableDesc tableDesc = this.getTableDesc(modelDimensionDesc.getTable());
            for (String column : modelDimensionDesc.getColumns()) {
                ColumnDesc columnDesc = tableDesc.findColumnByName(column);
                TblColRef tcr = new TblColRef(columnDesc);
                this.allColumns.add(tcr);
                this.allDimensions.add(tcr);
                this.measureDescs.add(this.makeHLLMeasure(columnDesc, "hllc10"));
            }
            if (allTableNames.contains(tableDesc.getIdentity())) continue;
            allTableNames.add(tableDesc.getIdentity());
            this.allTables.add(tableDesc);
        }
        for (String column : this.metricNames) {
            TableDesc tableDesc = this.getTableDesc(this.getFactTableName());
            ColumnDesc columnDesc = tableDesc.findColumnByName(column);
            this.allColumns.add(new TblColRef(columnDesc));
            this.measureDescs.add(this.makeNormalMeasure("SUM", columnDesc));
            this.measureDescs.add(this.makeNormalMeasure("MIN", columnDesc));
            this.measureDescs.add(this.makeNormalMeasure("MAX", columnDesc));
            if (allTableNames.contains(tableDesc.getIdentity())) continue;
            allTableNames.add(tableDesc.getIdentity());
            this.allTables.add(tableDesc);
        }
        this.bitmapCols = new int[ModelDimensionDesc.getColumnCount(this.bitmapDimensions)];
        this.valueCols = new int[ModelDimensionDesc.getColumnCount(this.valueDimensions)];
        this.metricsCols = new int[this.metricNames.length];
        this.metricsColSet = new BitSet(this.getTableDesc(this.getFactTableName()).getColumnCount());
        int totalIndex = 0;
        for (i = 0; i < this.bitmapCols.length; ++i) {
            this.bitmapCols[i] = totalIndex++;
        }
        for (i = 0; i < this.valueCols.length; ++i) {
            this.valueCols[i] = totalIndex++;
        }
        i = 0;
        while (i < this.metricsCols.length) {
            this.metricsCols[i] = totalIndex;
            this.metricsColSet.set(totalIndex);
            ++i;
            ++totalIndex;
        }
        this.tsCol = -1;
        for (i = 0; i < this.allColumns.size(); ++i) {
            TblColRef col = this.allColumns.get(i);
            if (!col.isSameAs(this.getFactTableName(), this.timestampDimension)) continue;
            this.tsCol = i;
            break;
        }
        if (this.tsCol < 0) {
            throw new RuntimeException("timestamp_dimension is not in bitmapDimensions or valueDimensions");
        }
    }

    private TableDesc getTableDesc(String tableName) {
        return MetadataManager.getInstance(this.config).getTableDesc(tableName);
    }

    public String getResourcePath() {
        return IIDesc.getIIDescResourcePath(this.name);
    }

    public static String getIIDescResourcePath(String descName) {
        return "/invertedindex_desc/" + descName + ".json";
    }

    public List<MeasureDesc> getMeasures() {
        return this.measureDescs;
    }

    public List<FunctionDesc> listAllFunctions() {
        ArrayList<FunctionDesc> functions = new ArrayList<FunctionDesc>();
        for (MeasureDesc m : this.measureDescs) {
            functions.add(m.getFunction());
        }
        return functions;
    }

    private MeasureDesc makeNormalMeasure(String func, ColumnDesc columnDesc) {
        String columnName = columnDesc.getName();
        String returnType = columnDesc.getTypeName();
        MeasureDesc measureDesc = new MeasureDesc();
        FunctionDesc f1 = new FunctionDesc();
        f1.setExpression(func);
        ParameterDesc p1 = new ParameterDesc();
        p1.setType("column");
        p1.setValue(columnName);
        p1.setColRefs((List<TblColRef>)ImmutableList.of((Object)new TblColRef(columnDesc)));
        f1.setParameter(p1);
        f1.setReturnType(returnType);
        if (f1.isSum() && f1.getReturnDataType().isIntegerFamily()) {
            f1.setReturnType("bigint");
        }
        measureDesc.setFunction(f1);
        measureDesc.setName(func + "_" + columnName);
        return measureDesc;
    }

    private MeasureDesc makeHLLMeasure(ColumnDesc columnDesc, String hllType) {
        String columnName = columnDesc.getName();
        MeasureDesc measureDesc = new MeasureDesc();
        FunctionDesc f1 = new FunctionDesc();
        f1.setExpression("COUNT_DISTINCT");
        ParameterDesc p1 = new ParameterDesc();
        p1.setType("column");
        p1.setValue(columnName);
        p1.setColRefs((List<TblColRef>)ImmutableList.of((Object)new TblColRef(columnDesc)));
        f1.setParameter(p1);
        f1.setReturnType(hllType);
        measureDesc.setFunction(f1);
        measureDesc.setName("COUNT_DISTINCT_" + columnName);
        return measureDesc;
    }

    private MeasureDesc makeCountMeasure() {
        MeasureDesc measureDesc = new MeasureDesc();
        FunctionDesc f1 = new FunctionDesc();
        f1.setExpression("COUNT");
        ParameterDesc p1 = new ParameterDesc();
        p1.setType("constant");
        p1.setValue("1");
        f1.setParameter(p1);
        f1.setReturnType("bigint");
        measureDesc.setFunction(f1);
        measureDesc.setName("COUNT_1");
        return measureDesc;
    }

    public List<TableDesc> listTables() {
        return this.allTables;
    }

    public List<TblColRef> listAllColumns() {
        return this.allColumns;
    }

    public List<TblColRef> listAllDimensions() {
        return this.allDimensions;
    }

    public TblColRef findColumnRef(String table, String column) {
        ColumnDesc columnDesc = this.getTableDesc(table).findColumnByName(column);
        return new TblColRef(columnDesc);
    }

    public int findColumn(TblColRef col) {
        return this.allColumns.indexOf(col);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public void setModel(DataModelDesc model) {
        this.model = model;
    }

    public int getTimestampColumn() {
        return this.tsCol;
    }

    public int[] getBitmapColumns() {
        return this.bitmapCols;
    }

    public int[] getValueColumns() {
        return this.valueCols;
    }

    public int[] getMetricsColumns() {
        return this.metricsCols;
    }

    public short getSharding() {
        return this.sharding;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean isMetricsCol(TblColRef col) {
        if (!col.getTable().equalsIgnoreCase(this.getFactTableName())) {
            return false;
        }
        return this.isMetricsCol(this.findColumn(col));
    }

    public boolean isMetricsCol(int index) {
        return this.metricsColSet.get(index);
    }

    public String getFactTableName() {
        return this.model.getFactTable().toUpperCase();
    }

    public String getTimestampDimension() {
        return this.timestampDimension;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String calculateSignature() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            StringBuilder sigString = new StringBuilder();
            sigString.append(this.name).append("|").append(this.getFactTableName()).append("|").append(this.timestampDimension).append("|").append(JsonUtil.writeValueAsString(this.bitmapDimensions)).append("|").append(JsonUtil.writeValueAsString(this.valueDimensions)).append("|").append(JsonUtil.writeValueAsString(this.metricNames)).append("|").append(this.sharding).append("|").append(this.sliceSize);
            byte[] signature = md.digest(sigString.toString().getBytes());
            return new String(Base64.encodeBase64((byte[])signature));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to calculate signature");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to calculate signature");
        }
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int engineType) {
        this.engineType = engineType;
    }
}

