/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.measure;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.LongMutable;

public class FixedPointLongCodec
extends FixedLenMeasureCodec<LongMutable> {
    private static final int SIZE = 8;
    int scale;
    DataType type;
    LongMutable current = new LongMutable();

    public FixedPointLongCodec(DataType type) {
        this.type = type;
        this.scale = Math.max(0, type.getScale());
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    long getValueIgnoringDecimalPoint(String value) {
        int index = value.indexOf(46);
        if (index == 0 || index == value.length() - 1) {
            throw new RuntimeException("Bad decimal format: " + value);
        }
        if (index < 0) {
            return Long.valueOf(value) * (long)((int)Math.pow(10.0, this.scale));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(value.substring(0, index));
        int end = Math.min(value.length(), index + this.scale + 1);
        sb.append(value.substring(index + 1, end));
        int diff = index + this.scale + 1 - value.length();
        for (int i = 0; i < diff; ++i) {
            sb.append('0');
        }
        return Long.valueOf(sb.toString());
    }

    String restoreDecimalPoint(long value) {
        if (this.scale < 0) {
            throw new RuntimeException("Bad scale: " + this.scale + " with value: " + value);
        }
        if (this.scale == 0) {
            return Long.toString(value);
        }
        return String.format("%." + this.scale + "f", (double)value / Math.pow(10.0, this.scale));
    }

    @Override
    public LongMutable valueOf(String value) {
        if (value == null) {
            this.current.set(0L);
        } else {
            this.current.set(this.getValueIgnoringDecimalPoint(value));
        }
        return this.current;
    }

    @Override
    public String getValue() {
        if (this.scale == 0) {
            return this.current.toString();
        }
        return this.restoreDecimalPoint(this.current.get());
    }

    @Override
    public LongMutable read(byte[] buf, int offset) {
        this.current.set(BytesUtil.readLong(buf, offset, 8));
        return this.current;
    }

    @Override
    public void write(LongMutable v, byte[] buf, int offset) {
        BytesUtil.writeLong(v == null ? 0L : v.get(), buf, offset, 8);
    }

    @Override
    public LongMutable read(ByteBuffer buffer) {
        this.current.set(BytesUtil.readLong(buffer, 8));
        return this.current;
    }
}

