/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.invertedindex.index.RawTableRecord;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.LongMutable;

public class TableRecordInfoDigest {
    private String[] metricDataTypes;
    private int nColumns;
    private int byteFormLen;
    private int[] offsets;
    private int[] dictMaxIds;
    private int[] lengths;
    private boolean[] isMetric;
    private FixedLenMeasureCodec<?>[] measureCodecs;
    private static final BytesSerializer<TableRecordInfoDigest> serializer = new BytesSerializer<TableRecordInfoDigest>(){

        @Override
        public void serialize(TableRecordInfoDigest value, ByteBuffer out) {
            BytesUtil.writeVInt(value.nColumns, out);
            BytesUtil.writeVInt(value.byteFormLen, out);
            BytesUtil.writeIntArray(value.offsets, out);
            BytesUtil.writeIntArray(value.dictMaxIds, out);
            BytesUtil.writeIntArray(value.lengths, out);
            BytesUtil.writeBooleanArray(value.isMetric, out);
            BytesUtil.writeAsciiStringArray(value.metricDataTypes, out);
        }

        @Override
        public TableRecordInfoDigest deserialize(ByteBuffer in) {
            TableRecordInfoDigest result = new TableRecordInfoDigest();
            result.nColumns = BytesUtil.readVInt(in);
            result.byteFormLen = BytesUtil.readVInt(in);
            TableRecordInfoDigest.access$202(result, BytesUtil.readIntArray(in));
            TableRecordInfoDigest.access$302(result, BytesUtil.readIntArray(in));
            TableRecordInfoDigest.access$402(result, BytesUtil.readIntArray(in));
            TableRecordInfoDigest.access$502(result, BytesUtil.readBooleanArray(in));
            TableRecordInfoDigest.access$602(result, BytesUtil.readAsciiStringArray(in));
            return result;
        }
    };

    public TableRecordInfoDigest(int nColumns, int byteFormLen, int[] offsets, int[] dictMaxIds, int[] lengths, boolean[] isMetric, String[] metricDataTypes) {
        this.nColumns = nColumns;
        this.byteFormLen = byteFormLen;
        this.offsets = offsets;
        this.dictMaxIds = dictMaxIds;
        this.lengths = lengths;
        this.isMetric = isMetric;
        this.metricDataTypes = metricDataTypes;
        this.measureCodecs = new FixedLenMeasureCodec[nColumns];
        for (int i = 0; i < isMetric.length; ++i) {
            if (!isMetric[i]) continue;
            this.measureCodecs[i] = FixedLenMeasureCodec.get(DataType.getType(metricDataTypes[i]));
        }
    }

    private TableRecordInfoDigest() {
    }

    public int getByteFormLen() {
        return this.byteFormLen;
    }

    public boolean isMetrics(int col) {
        return this.isMetric[col];
    }

    public boolean[] isMetrics() {
        return this.isMetric;
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public int offset(int col) {
        return this.offsets[col];
    }

    public int length(int col) {
        return this.lengths[col];
    }

    public int getMaxID(int col) {
        return this.dictMaxIds[col];
    }

    public boolean[] getIsMetric() {
        return this.isMetric;
    }

    public String[] getMetricDataTypes() {
        return this.metricDataTypes;
    }

    public RawTableRecord createTableRecordBytes() {
        return new RawTableRecord(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nColumns, this.offsets, this.dictMaxIds, this.lengths, this.isMetric, this.metricDataTypes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableRecordInfoDigest) {
            TableRecordInfoDigest other = (TableRecordInfoDigest)obj;
            return Objects.equal((Object)this.nColumns, (Object)other.nColumns) && Arrays.equals(this.offsets, other.offsets) && Arrays.equals(this.dictMaxIds, other.dictMaxIds) && Arrays.equals(this.lengths, other.lengths) && Arrays.equals(this.isMetric, other.isMetric) && Arrays.equals(this.metricDataTypes, other.metricDataTypes);
        }
        return false;
    }

    public FixedLenMeasureCodec<LongMutable> codec(int col) {
        return this.measureCodecs[col];
    }

    public static byte[] serialize(TableRecordInfoDigest o) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        serializer.serialize(o, buf);
        byte[] result = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, result, 0, buf.position());
        return result;
    }

    public static TableRecordInfoDigest deserialize(byte[] bytes) {
        return serializer.deserialize(ByteBuffer.wrap(bytes));
    }

    public static TableRecordInfoDigest deserialize(ByteBuffer buffer) {
        return serializer.deserialize(buffer);
    }

    static /* synthetic */ int[] access$202(TableRecordInfoDigest x0, int[] x1) {
        x0.offsets = x1;
        return x1;
    }

    static /* synthetic */ int[] access$302(TableRecordInfoDigest x0, int[] x1) {
        x0.dictMaxIds = x1;
        return x1;
    }

    static /* synthetic */ int[] access$402(TableRecordInfoDigest x0, int[] x1) {
        x0.lengths = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$502(TableRecordInfoDigest x0, boolean[] x1) {
        x0.isMetric = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(TableRecordInfoDigest x0, String[] x1) {
        x0.metricDataTypes = x1;
        return x1;
    }
}

