/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kylin.common.util.StreamingBatch;
import org.apache.kylin.common.util.StreamingMessage;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.index.BatchSliceMaker;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.invertedindex.model.IIDesc;
import org.apache.kylin.invertedindex.util.IIDictionaryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SliceBuilder {
    private static Logger logger = LoggerFactory.getLogger(SliceBuilder.class);
    private final BatchSliceMaker sliceMaker;
    private final IIDesc iiDesc;

    public SliceBuilder(IIDesc desc, short shard) {
        this.iiDesc = desc;
        this.sliceMaker = new BatchSliceMaker(desc, shard);
    }

    public Slice buildSlice(StreamingBatch microStreamBatch) throws IOException {
        List messages = Lists.transform(microStreamBatch.getMessages(), (Function)new Function<StreamingMessage, List<String>>(){

            @Nullable
            public List<String> apply(@Nullable StreamingMessage input) {
                return input.getData();
            }
        });
        Dictionary<?>[] dictionaries = IIDictionaryBuilder.buildDictionary(messages, this.iiDesc);
        TableRecordInfo tableRecordInfo = new TableRecordInfo(this.iiDesc, dictionaries);
        return this.build(messages, tableRecordInfo, dictionaries);
    }

    private Slice build(List<List<String>> table, final TableRecordInfo tableRecordInfo, Dictionary<?>[] localDictionary) {
        Slice slice = this.sliceMaker.makeSlice(tableRecordInfo.getDigest(), Lists.transform(table, (Function)new Function<List<String>, TableRecord>(){

            @Nullable
            public TableRecord apply(@Nullable List<String> input) {
                TableRecord result = tableRecordInfo.createTableRecord();
                for (int i = 0; i < input.size(); ++i) {
                    result.setValueString(i, input.get(i));
                }
                return result;
            }
        }));
        slice.setLocalDictionaries(localDictionary);
        return slice;
    }
}

