/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.google.common.base.Objects;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import java.util.Iterator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.invertedindex.index.ColumnValueContainer;
import org.apache.kylin.invertedindex.index.RawTableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;

public class Slice
implements Iterable<RawTableRecord>,
Comparable<Slice> {
    final TableRecordInfoDigest info;
    final int nColumns;
    final short shard;
    final long timestamp;
    final int nRecords;
    final ColumnValueContainer[] containers;
    private Dictionary<?>[] localDictionaries;

    public Slice(TableRecordInfoDigest digest, short shard, long timestamp, ColumnValueContainer[] containers) {
        this.info = digest;
        this.nColumns = digest.getColumnCount();
        this.shard = shard;
        this.timestamp = timestamp;
        this.nRecords = containers[0].getSize();
        this.containers = containers;
        assert (this.nColumns == containers.length);
        for (int i = 0; i < this.nColumns; ++i) {
            assert (this.nRecords == containers[i].getSize());
        }
    }

    public Dictionary<?>[] getLocalDictionaries() {
        return this.localDictionaries;
    }

    public void setLocalDictionaries(Dictionary<?>[] localDictionaries) {
        this.localDictionaries = localDictionaries;
    }

    public int getRecordCount() {
        return this.nRecords;
    }

    public short getShard() {
        return this.shard;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ColumnValueContainer[] getColumnValueContainers() {
        return this.containers;
    }

    public ColumnValueContainer getColumnValueContainer(int col) {
        return this.containers[col];
    }

    public Iterator<RawTableRecord> iterateWithBitmap(final ConciseSet resultBitMap) {
        if (resultBitMap == null) {
            return this.iterator();
        }
        final RawTableRecord rec = this.info.createTableRecordBytes();
        final ImmutableBytesWritable temp = new ImmutableBytesWritable();
        return new Iterator<RawTableRecord>(){
            int i = 0;
            int iteratedCount = 0;
            int resultSize = resultBitMap.size();

            @Override
            public boolean hasNext() {
                return this.iteratedCount < this.resultSize;
            }

            @Override
            public RawTableRecord next() {
                while (!resultBitMap.contains(this.i)) {
                    ++this.i;
                }
                for (int col = 0; col < Slice.this.nColumns; ++col) {
                    Slice.this.containers[col].getValueAt(this.i, temp);
                    rec.setValueBytes(col, temp);
                }
                ++this.iteratedCount;
                ++this.i;
                return rec;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<RawTableRecord> iterator() {
        return new Iterator<RawTableRecord>(){
            int i = 0;
            RawTableRecord rec;
            ImmutableBytesWritable temp;
            {
                this.rec = Slice.this.info.createTableRecordBytes();
                this.temp = new ImmutableBytesWritable();
            }

            @Override
            public boolean hasNext() {
                return this.i < Slice.this.nRecords;
            }

            @Override
            public RawTableRecord next() {
                for (int col = 0; col < Slice.this.nColumns; ++col) {
                    Slice.this.containers[col].getValueAt(this.i, this.temp);
                    this.rec.setValueBytes(col, this.temp);
                }
                ++this.i;
                return this.rec;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + this.shard;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.shard != other.shard) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Objects.equal((Object)this.info, (Object)other.info);
    }

    @Override
    public int compareTo(Slice o) {
        int comp = this.shard - o.shard;
        if (comp != 0) {
            return comp;
        }
        comp = (int)(this.timestamp - o.timestamp);
        return comp;
    }

    public TableRecordInfoDigest getInfo() {
        return this.info;
    }
}

