/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.measure.FixedLenMeasureCodec;
import org.apache.kylin.metadata.datatype.LongMutable;

public class RawTableRecord
implements Cloneable {
    TableRecordInfoDigest digest;
    private byte[] buf;

    public RawTableRecord(TableRecordInfoDigest info) {
        this.digest = info;
        this.buf = new byte[info.getByteFormLen()];
        this.reset();
    }

    public RawTableRecord(RawTableRecord another) {
        this.digest = another.digest;
        this.buf = Bytes.copy(another.buf);
    }

    public void reset() {
        Arrays.fill(this.buf, (byte)-1);
    }

    public boolean isMetric(int col) {
        return this.digest.isMetrics(col);
    }

    public FixedLenMeasureCodec<LongMutable> codec(int col) {
        return this.digest.codec(col);
    }

    public final int length(int col) {
        return this.digest.length(col);
    }

    public final int offset(int col) {
        return this.digest.offset(col);
    }

    public int getColumnCount() {
        return this.digest.getColumnCount();
    }

    public void setValueID(int col, int id) {
        BytesUtil.writeUnsigned(id, this.buf, this.digest.offset(col), this.digest.length(col));
    }

    public int getValueID(int col) {
        return BytesUtil.readUnsigned(this.buf, this.digest.offset(col), this.digest.length(col));
    }

    public void setValueMetrics(int col, LongMutable value) {
        this.digest.codec(col).write(value, this.buf, this.digest.offset(col));
    }

    public String getValueMetric(int col) {
        this.digest.codec(col).read(this.buf, this.digest.offset(col));
        return (String)this.digest.codec(col).getValue();
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        assert (this.buf.length == length);
        System.arraycopy(bytes, offset, this.buf, 0, length);
    }

    public void setValueBytes(int col, ImmutableBytesWritable bytes) {
        System.arraycopy(bytes.get(), bytes.getOffset(), this.buf, this.digest.offset(col), this.digest.length(col));
    }

    public void getValueBytes(int col, ImmutableBytesWritable bytes) {
        bytes.set(this.buf, this.offset(col), this.length(col));
    }

    public Object clone() {
        return new RawTableRecord(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.buf);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawTableRecord other = (RawTableRecord)obj;
        return Arrays.equals(this.buf, other.buf);
    }
}

