/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.invertedindex.index;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.kylin.invertedindex.index.ColumnValueContainer;
import org.apache.kylin.invertedindex.index.CompressedValueContainer;
import org.apache.kylin.invertedindex.index.Slice;
import org.apache.kylin.invertedindex.index.TableRecord;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.invertedindex.model.IIDesc;

public class BatchSliceMaker {
    private final int nColumns;
    private final int nRecordsCap;
    private final short shard;
    private final IIDesc desc;
    private long sliceTimestamp;
    transient ImmutableBytesWritable temp = new ImmutableBytesWritable();

    public BatchSliceMaker(IIDesc desc, short shard) {
        this.desc = desc;
        this.nColumns = desc.listAllColumns().size();
        this.nRecordsCap = Math.max(1, desc.getSliceSize());
        this.shard = shard;
        this.sliceTimestamp = Long.MIN_VALUE;
    }

    public Slice makeSlice(TableRecordInfoDigest digest, List<TableRecord> records) {
        Preconditions.checkArgument((records != null && !records.isEmpty() ? 1 : 0) != 0, (Object)"records cannot be empty");
        Preconditions.checkArgument((records.size() <= this.nRecordsCap ? 1 : 0) != 0, (Object)("batch count cannot exceed " + this.nRecordsCap));
        this.sliceTimestamp = this.increaseSliceTimestamp(records.get(0).getTimestamp());
        ColumnValueContainer[] containers = new ColumnValueContainer[this.nColumns];
        for (int i : this.desc.getValueColumns()) {
            containers[i] = new CompressedValueContainer(digest, i, this.nRecordsCap);
        }
        for (int i : this.desc.getMetricsColumns()) {
            containers[i] = new CompressedValueContainer(digest, i, this.nRecordsCap);
        }
        for (TableRecord record : records) {
            for (int i = 0; i < this.nColumns; ++i) {
                record.getValueBytes(i, this.temp);
                containers[i].append(this.temp);
            }
        }
        return new Slice(digest, this.shard, this.sliceTimestamp, containers);
    }

    private long increaseSliceTimestamp(long timestamp) {
        if (timestamp <= this.sliceTimestamp) {
            return this.sliceTimestamp + 1L;
        }
        return timestamp;
    }
}

