/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable.benchmark;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTSampleCodeSystem;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.benchmark.SortedGTRecordGenerator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;

public class GTScannerBenchmark {
    final GTInfo info;
    final SortedGTRecordGenerator gen;
    final ImmutableBitSet dimensions = ImmutableBitSet.valueOf(0, 1, 2, 3, 4);
    final ImmutableBitSet metrics = ImmutableBitSet.valueOf(5, 6);
    final String[] aggrFuncs = new String[]{"SUM", "SUM"};
    final long N = 10000000L;
    final long genTime;

    public GTScannerBenchmark() {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setCodeSystem(new GTSampleCodeSystem());
        DataType tint = DataType.getType("int4");
        DataType tlong = DataType.getType("long8");
        builder.setColumns(tint, tint, tint, tint, tint, tlong, tlong);
        builder.setPrimaryKey(ImmutableBitSet.valueOf(0, 1, 2, 3, 4));
        this.info = builder.build();
        this.gen = new SortedGTRecordGenerator(this.info);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(100L, 4, null);
        this.gen.addMeasure(8);
        this.gen.addMeasure(8);
        long t = System.currentTimeMillis();
        this.testGenerate();
        this.genTime = System.currentTimeMillis() - t;
    }

    public void testGenerate() {
        long count = 0L;
        for (GTRecord rec : this.gen.generate(10000000L)) {
            ++count;
        }
    }

    public void testAggregate2() throws IOException {
        this.testAggregate(ImmutableBitSet.valueOf(0, 1));
    }

    public void testAggregate2_() throws IOException {
        this.testAggregate(ImmutableBitSet.valueOf(0, 2));
    }

    public void testAggregate4() throws IOException {
        this.testAggregate(ImmutableBitSet.valueOf(0, 1, 2, 3));
    }

    public void testAggregate5() throws IOException {
        this.testAggregate(ImmutableBitSet.valueOf(0, 1, 2, 3, 4));
    }

    private void testAggregate(ImmutableBitSet groupBy) throws IOException {
        long t = System.currentTimeMillis();
        GTScanRequest req = new GTScanRequest(this.info, null, this.dimensions, groupBy, this.metrics, this.aggrFuncs, null, true, 10.0);
        IGTScanner scanner = req.decorateScanner(this.gen.generate(10000000L));
        long count = 0L;
        for (GTRecord rec : scanner) {
            ++count;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("10000000 records aggregated to " + count + ", " + this.calcSpeed(t) + "K rec/sec");
    }

    private int calcSpeed(long t) {
        double sec = (double)(t - this.genTime) / 1000.0;
        return (int)(1.0E7 / sec / 1000.0);
    }

    public void testFilter1() throws IOException {
        this.testFilter(this.eq(this.col(1), 1, 5, 7));
    }

    public void testFilter2() throws IOException {
        this.testFilter(this.and(this.gt(this.col(0), 5), this.eq(this.col(2), 2, 4)));
    }

    public void testFilter3() throws IOException {
        this.testFilter(this.and(this.gt(this.col(0), 2), this.eq(this.col(4), 1, 3, 5, 9, 12, 14, 23, 43, 52, 78, 92), this.or(this.eq(this.col(1), 2, 4), this.eq(this.col(2), 2, 4, 5, 9))));
    }

    private void testFilter(TupleFilter filter) throws IOException {
        long t = System.currentTimeMillis();
        GTScanRequest req = new GTScanRequest(this.info, null, this.info.getAllColumns(), filter);
        IGTScanner scanner = req.decorateScanner(this.gen.generate(10000000L));
        long count = 0L;
        for (GTRecord rec : scanner) {
            ++count;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("10000000 records filtered to " + count + ", " + this.calcSpeed(t) + "K rec/sec");
    }

    private LogicalTupleFilter and(TupleFilter ... filters) {
        return this.logical(TupleFilter.FilterOperatorEnum.AND, filters);
    }

    private LogicalTupleFilter or(TupleFilter ... filters) {
        return this.logical(TupleFilter.FilterOperatorEnum.OR, filters);
    }

    private LogicalTupleFilter logical(TupleFilter.FilterOperatorEnum op, TupleFilter[] filters) {
        LogicalTupleFilter r = new LogicalTupleFilter(op);
        for (TupleFilter f : filters) {
            r.addChild(f);
        }
        return r;
    }

    private CompareTupleFilter gt(ColumnTupleFilter col, int v) {
        CompareTupleFilter r = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GT);
        r.addChild(col);
        int c = col.getColumn().getColumnDesc().getZeroBasedIndex();
        int len = this.info.getCodeSystem().maxCodeLength(c);
        ByteArray bytes = new ByteArray(len);
        BytesUtil.writeLong(v, bytes.array(), bytes.offset(), len);
        r.addChild(new ConstantTupleFilter(bytes));
        return r;
    }

    private CompareTupleFilter eq(ColumnTupleFilter col, int ... values) {
        CompareTupleFilter r = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
        r.addChild(col);
        ArrayList list = Lists.newArrayList();
        for (int v : values) {
            int c = col.getColumn().getColumnDesc().getZeroBasedIndex();
            int len = this.info.getCodeSystem().maxCodeLength(c);
            ByteArray bytes = new ByteArray(len);
            BytesUtil.writeLong(v, bytes.array(), bytes.offset(), len);
            list.add(bytes);
        }
        r.addChild(new ConstantTupleFilter(list));
        return r;
    }

    private ColumnTupleFilter col(int i) {
        return new ColumnTupleFilter(this.info.colRef(i));
    }

    public static void main(String[] args) throws IOException {
        GTScannerBenchmark benchmark = new GTScannerBenchmark();
        benchmark.testFilter1();
        benchmark.testFilter2();
        benchmark.testFilter3();
        benchmark.testAggregate2();
        benchmark.testAggregate2_();
        benchmark.testAggregate4();
        benchmark.testAggregate5();
    }
}

