/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.gridtable.EmptyGTScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerWorker {
    private static final Logger logger = LoggerFactory.getLogger(ScannerWorker.class);
    private IGTScanner internal = null;

    public ScannerWorker(CubeSegment cubeSeg, Cuboid cuboid, GTScanRequest scanRequest) {
        if (scanRequest == null) {
            logger.info("Segment {} will be skipped", (Object)cubeSeg);
            this.internal = new EmptyGTScanner(0);
            return;
        }
        GTInfo info = scanRequest.getInfo();
        try {
            IGTStorage rpc = "scan".equalsIgnoreCase(BackdoorToggles.getHbaseCubeQueryProtocol()) ? (IGTStorage)Class.forName("org.apache.kylin.storage.hbase.cube.v2.CubeHBaseScanRPC").getConstructor(CubeSegment.class, Cuboid.class, GTInfo.class).newInstance(cubeSeg, cuboid, info) : (IGTStorage)Class.forName(KylinConfig.getInstanceFromEnv().getDefaultIGTStorage()).getConstructor(CubeSegment.class, Cuboid.class, GTInfo.class).newInstance(cubeSeg, cuboid, info);
            this.internal = rpc.getGTScanner(scanRequest);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("error", e);
        }
    }

    public Iterator<GTRecord> iterator() {
        return this.internal.iterator();
    }

    public void close() throws IOException {
        this.internal.close();
    }

    public int getScannedRowCount() {
        return this.internal.getScannedRowCount();
    }
}

