/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.EmptyGTScanner;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTFilterScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public class GTScanRequest {
    private GTInfo info;
    private List<GTScanRange> ranges;
    private ImmutableBitSet columns;
    private transient ImmutableBitSet selectedColBlocks;
    private TupleFilter filterPushDown;
    private ImmutableBitSet aggrGroupBy;
    private ImmutableBitSet aggrMetrics;
    private String[] aggrMetricsFuncs;
    private boolean allowPreAggregation = true;
    private double aggrCacheGB = 0.0;
    public static final BytesSerializer<GTScanRequest> serializer = new BytesSerializer<GTScanRequest>(){

        @Override
        public void serialize(GTScanRequest value, ByteBuffer out) {
            GTInfo.serializer.serialize(value.info, out);
            BytesUtil.writeVInt(value.ranges.size(), out);
            for (GTScanRange range : value.ranges) {
                this.serializeGTRecord(range.pkStart, out);
                this.serializeGTRecord(range.pkEnd, out);
                BytesUtil.writeVInt(range.fuzzyKeys.size(), out);
                for (GTRecord f : range.fuzzyKeys) {
                    this.serializeGTRecord(f, out);
                }
            }
            ImmutableBitSet.serializer.serialize(value.columns, out);
            BytesUtil.writeByteArray(GTUtil.serializeGTFilter(value.filterPushDown, value.info), out);
            ImmutableBitSet.serializer.serialize(value.aggrGroupBy, out);
            ImmutableBitSet.serializer.serialize(value.aggrMetrics, out);
            BytesUtil.writeAsciiStringArray(value.aggrMetricsFuncs, out);
            BytesUtil.writeVInt(value.allowPreAggregation ? 1 : 0, out);
            out.putDouble(value.aggrCacheGB);
        }

        @Override
        public GTScanRequest deserialize(ByteBuffer in) {
            GTInfo sInfo = GTInfo.serializer.deserialize(in);
            ArrayList sRanges = Lists.newArrayList();
            int sRangesCount = BytesUtil.readVInt(in);
            for (int rangeIdx = 0; rangeIdx < sRangesCount; ++rangeIdx) {
                GTRecord sPkStart = this.deserializeGTRecord(in, sInfo);
                GTRecord sPkEnd = this.deserializeGTRecord(in, sInfo);
                ArrayList sFuzzyKeys = Lists.newArrayList();
                int sFuzzyKeySize = BytesUtil.readVInt(in);
                for (int i = 0; i < sFuzzyKeySize; ++i) {
                    sFuzzyKeys.add(this.deserializeGTRecord(in, sInfo));
                }
                GTScanRange sRange = new GTScanRange(sPkStart, sPkEnd, sFuzzyKeys);
                sRanges.add(sRange);
            }
            ImmutableBitSet sColumns = ImmutableBitSet.serializer.deserialize(in);
            TupleFilter sGTFilter = GTUtil.deserializeGTFilter(BytesUtil.readByteArray(in), sInfo);
            ImmutableBitSet sAggGroupBy = ImmutableBitSet.serializer.deserialize(in);
            ImmutableBitSet sAggrMetrics = ImmutableBitSet.serializer.deserialize(in);
            String[] sAggrMetricFuncs = BytesUtil.readAsciiStringArray(in);
            boolean sAllowPreAggr = BytesUtil.readVInt(in) == 1;
            double sAggrCacheGB = in.getDouble();
            return new GTScanRequest(sInfo, sRanges, sColumns, sAggGroupBy, sAggrMetrics, sAggrMetricFuncs, sGTFilter, sAllowPreAggr, sAggrCacheGB);
        }

        private void serializeGTRecord(GTRecord gtRecord, ByteBuffer out) {
            BytesUtil.writeVInt(gtRecord.cols.length, out);
            for (ByteArray col : gtRecord.cols) {
                col.exportData(out);
            }
            ImmutableBitSet.serializer.serialize(gtRecord.maskForEqualHashComp, out);
        }

        private GTRecord deserializeGTRecord(ByteBuffer in, GTInfo sInfo) {
            int colLength = BytesUtil.readVInt(in);
            ByteArray[] sCols = new ByteArray[colLength];
            for (int i = 0; i < colLength; ++i) {
                sCols[i] = ByteArray.importData(in);
            }
            ImmutableBitSet sMaskForEqualHashComp = ImmutableBitSet.serializer.deserialize(in);
            return new GTRecord(sInfo, sMaskForEqualHashComp, sCols);
        }
    };

    public GTScanRequest(GTInfo info, List<GTScanRange> ranges, ImmutableBitSet columns, TupleFilter filterPushDown) {
        this.info = info;
        this.ranges = ranges == null ? Lists.newArrayList((Object[])new GTScanRange[]{new GTScanRange(new GTRecord(info), new GTRecord(info))}) : ranges;
        this.columns = columns;
        this.filterPushDown = filterPushDown;
        this.validate(info);
    }

    public GTScanRequest(GTInfo info, List<GTScanRange> ranges, ImmutableBitSet dimensions, ImmutableBitSet aggrGroupBy, ImmutableBitSet aggrMetrics, String[] aggrMetricsFuncs, TupleFilter filterPushDown, boolean allowPreAggregation, double aggrCacheGB) {
        this.info = info;
        this.ranges = ranges == null ? Lists.newArrayList((Object[])new GTScanRange[]{new GTScanRange(new GTRecord(info), new GTRecord(info))}) : ranges;
        this.columns = dimensions;
        this.filterPushDown = filterPushDown;
        this.aggrGroupBy = aggrGroupBy;
        this.aggrMetrics = aggrMetrics;
        this.aggrMetricsFuncs = aggrMetricsFuncs;
        this.allowPreAggregation = allowPreAggregation;
        this.aggrCacheGB = aggrCacheGB;
        this.validate(info);
    }

    private void validate(GTInfo info) {
        if (this.hasAggregation()) {
            if (this.aggrGroupBy.intersects(this.aggrMetrics)) {
                throw new IllegalStateException();
            }
            if (this.aggrMetrics.cardinality() != this.aggrMetricsFuncs.length) {
                throw new IllegalStateException();
            }
            if (this.columns == null) {
                this.columns = ImmutableBitSet.EMPTY;
            }
            this.columns = this.columns.or(this.aggrGroupBy);
            this.columns = this.columns.or(this.aggrMetrics);
        }
        if (this.columns == null) {
            this.columns = info.colAll;
        }
        this.selectedColBlocks = info.selectColumnBlocks(this.columns);
        if (this.hasFilterPushDown()) {
            this.validateFilterPushDown(info);
        }
    }

    private void validateFilterPushDown(GTInfo info) {
        if (!this.hasFilterPushDown()) {
            return;
        }
        HashSet filterColumns = Sets.newHashSet();
        TupleFilter.collectColumns(this.filterPushDown, filterColumns);
        for (TblColRef col : filterColumns) {
            info.validateColRef(col);
            this.columns = this.columns.set(col.getColumnDesc().getZeroBasedIndex());
        }
        if (!TupleFilter.isEvaluableRecursively(this.filterPushDown)) {
            HashSet unevaluableColumns = Sets.newHashSet();
            this.filterPushDown = GTUtil.convertFilterUnevaluatable(this.filterPushDown, info, unevaluableColumns);
            if (this.hasAggregation()) {
                for (TblColRef col : unevaluableColumns) {
                    this.aggrGroupBy = this.aggrGroupBy.set(col.getColumnDesc().getZeroBasedIndex());
                }
            }
        }
    }

    public IGTScanner decorateScanner(IGTScanner scanner) throws IOException {
        return this.decorateScanner(scanner, true, true);
    }

    public IGTScanner decorateScanner(IGTScanner scanner, boolean doFilter, boolean doAggr) throws IOException {
        IGTScanner result = scanner;
        if (!doFilter) {
            int scanned = this.lookAndForget(result);
            return new EmptyGTScanner(scanned);
        }
        if (this.hasFilterPushDown()) {
            result = new GTFilterScanner(result, this);
        }
        if (!doAggr) {
            int scanned = result.getScannedRowCount();
            this.lookAndForget(result);
            return new EmptyGTScanner(scanned);
        }
        if (this.allowPreAggregation && this.hasAggregation()) {
            result = new GTAggregateScanner(result, this);
        }
        return result;
    }

    private int lookAndForget(IGTScanner scanner) {
        int meaninglessByte = 0;
        int scanned = 0;
        for (GTRecord gtRecord : scanner) {
            ++scanned;
            for (ByteArray col : gtRecord.getInternal()) {
                if (col == null) continue;
                int endIndex = col.offset() + col.length();
                for (int i = col.offset(); i < endIndex; ++i) {
                    meaninglessByte = (byte)(meaninglessByte + col.array()[i]);
                }
            }
        }
        System.out.println("Meaningless byte is " + meaninglessByte);
        IOUtils.closeQuietly((Closeable)scanner);
        return scanned;
    }

    public boolean hasFilterPushDown() {
        return this.filterPushDown != null;
    }

    public boolean hasAggregation() {
        return this.aggrGroupBy != null && this.aggrMetrics != null && this.aggrMetricsFuncs != null;
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public List<GTScanRange> getGTScanRanges() {
        return this.ranges;
    }

    public void setGTScanRanges(List<GTScanRange> ranges) {
        this.ranges = ranges;
    }

    public ImmutableBitSet getSelectedColBlocks() {
        return this.selectedColBlocks;
    }

    public ImmutableBitSet getColumns() {
        return this.columns;
    }

    public TupleFilter getFilterPushDown() {
        return this.filterPushDown;
    }

    public ImmutableBitSet getAggrGroupBy() {
        return this.aggrGroupBy;
    }

    public ImmutableBitSet getAggrMetrics() {
        return this.aggrMetrics;
    }

    public String[] getAggrMetricsFuncs() {
        return this.aggrMetricsFuncs;
    }

    public double getAggrCacheGB() {
        return this.aggrCacheGB;
    }

    public void setAggrCacheGB(double gb) {
        this.aggrCacheGB = gb;
    }

    public String toString() {
        return "GTScanRequest [range=" + this.ranges + ", columns=" + this.columns + ", filterPushDown=" + this.filterPushDown + ", aggrGroupBy=" + this.aggrGroupBy + ", aggrMetrics=" + this.aggrMetrics + ", aggrMetricsFuncs=" + Arrays.toString(this.aggrMetricsFuncs) + "]";
    }
}

