/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;

public class GTScanRange {
    public final GTRecord pkStart;
    public final GTRecord pkEnd;
    public final List<GTRecord> fuzzyKeys;

    public GTScanRange(GTRecord pkStart, GTRecord pkEnd) {
        this(pkStart, pkEnd, null);
    }

    public GTScanRange(GTRecord pkStart, GTRecord pkEnd, List<GTRecord> fuzzyKeys) {
        GTInfo info = pkStart.info;
        assert (info == pkEnd.info);
        this.pkStart = pkStart;
        this.pkEnd = pkEnd;
        this.fuzzyKeys = fuzzyKeys == null ? Collections.emptyList() : fuzzyKeys;
    }

    public GTScanRange replaceGTInfo(GTInfo gtInfo) {
        ArrayList newFuzzyKeys = Lists.newArrayList();
        for (GTRecord input : this.fuzzyKeys) {
            newFuzzyKeys.add(new GTRecord(gtInfo, input.maskForEqualHashComp(), input.cols));
        }
        return new GTScanRange(new GTRecord(gtInfo, this.pkStart.maskForEqualHashComp(), this.pkStart.cols), new GTRecord(gtInfo, this.pkEnd.maskForEqualHashComp(), this.pkEnd.cols), newFuzzyKeys);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fuzzyKeys == null ? 0 : this.fuzzyKeys.hashCode());
        result = 31 * result + (this.pkEnd == null ? 0 : this.pkEnd.hashCode());
        result = 31 * result + (this.pkStart == null ? 0 : this.pkStart.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTScanRange other = (GTScanRange)obj;
        if (this.fuzzyKeys == null ? other.fuzzyKeys != null : !this.fuzzyKeys.equals(other.fuzzyKeys)) {
            return false;
        }
        if (this.pkEnd == null ? other.pkEnd != null : !this.pkEnd.equals(other.pkEnd)) {
            return false;
        }
        return !(this.pkStart == null ? other.pkStart != null : !this.pkStart.equals(other.pkStart));
    }

    public String toString() {
        return (this.pkStart == null ? "null" : this.pkStart.toString(this.pkStart.info.primaryKey)) + "-" + (this.pkEnd == null ? "null" : this.pkEnd.toString(this.pkEnd.info.primaryKey));
    }
}

