/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.streaming.util;

import com.google.common.base.Preconditions;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.engine.streaming.IStreamingInput;
import org.apache.kylin.engine.streaming.IStreamingOutput;
import org.apache.kylin.engine.streaming.StreamingBatchBuilder;
import org.apache.kylin.engine.streaming.cube.StreamingCubeBuilder;
import org.apache.kylin.metadata.realization.RealizationType;

public class StreamingUtils {
    public static IStreamingInput getStreamingInput() {
        return (IStreamingInput)ClassUtil.newInstance("org.apache.kylin.source.kafka.KafkaStreamingInput");
    }

    public static IStreamingOutput getStreamingOutput() {
        return (IStreamingOutput)ClassUtil.newInstance("org.apache.kylin.storage.hbase.steps.HBaseStreamingOutput");
    }

    public static StreamingBatchBuilder getMicroBatchBuilder(RealizationType realizationType, String realizationName) {
        Preconditions.checkNotNull((Object)realizationName);
        if (realizationType == RealizationType.CUBE) {
            return new StreamingCubeBuilder(realizationName);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }
}

