/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.engine.mr.KylinMapper;

public class RowKeyDistributionCheckerMapper
extends KylinMapper<Text, Text, Text, LongWritable> {
    String rowKeyStatsFilePath;
    byte[][] splitKeys;
    Map<Text, Long> resultMap;
    List<Text> keyList;

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.rowKeyStatsFilePath = context.getConfiguration().get("rowKeyStatsFilePath");
        this.splitKeys = this.getSplits(context.getConfiguration(), new Path(this.rowKeyStatsFilePath));
        this.resultMap = new HashMap<Text, Long>();
        this.keyList = new ArrayList<Text>();
        for (int i = 0; i < this.splitKeys.length; ++i) {
            Text key = new Text(this.splitKeys[i]);
            this.resultMap.put(key, 0L);
            this.keyList.add(new Text(this.splitKeys[i]));
        }
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        for (Text t : this.keyList) {
            if (key.compareTo((BinaryComparable)t) >= 0) continue;
            Long v = this.resultMap.get(t);
            long length = key.getLength() + value.getLength();
            v = v + length;
            this.resultMap.put(t, v);
            break;
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        LongWritable outputValue = new LongWritable();
        for (Map.Entry<Text, Long> kv : this.resultMap.entrySet()) {
            outputValue.set(kv.getValue().longValue());
            context.write((Object)kv.getKey(), (Object)outputValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getSplits(Configuration conf, Path path) {
        ArrayList<byte[]> rowkeyList = new ArrayList<byte[]>();
        SequenceFile.Reader reader = null;
        try {
            reader = new SequenceFile.Reader(path.getFileSystem(conf), path, conf);
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next(key, value)) {
                byte[] tmp = ((Text)key).copyBytes();
                if (rowkeyList.contains(tmp)) continue;
                rowkeyList.add(tmp);
            }
            IOUtils.closeStream((Closeable)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeStream(reader);
        }
        byte[][] retValue = (byte[][])rowkeyList.toArray((T[])new byte[rowkeyList.size()][]);
        return retValue;
    }
}

