/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCuboidReducer
extends KylinReducer<ByteArrayWritable, ByteArrayWritable, Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(InMemCuboidReducer.class);
    private MeasureCodec codec;
    private MeasureAggregators aggs;
    private int counter;
    private Object[] input;
    private Object[] result;
    private Text outputKey;
    private Text outputValue;
    private ByteBuffer valueBuf;

    protected void setup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String cubeName = context.getConfiguration().get("cube.name").toUpperCase();
        String segmentName = context.getConfiguration().get("cube.segment.name");
        boolean isMerge = Boolean.parseBoolean(context.getConfiguration().get("is.merge"));
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeDesc cubeDesc = cube.getDescriptor();
        CubeSegment cubeSeg = cube.getSegment(segmentName, SegmentStatusEnum.NEW);
        List<MeasureDesc> measuresDescs = cubeDesc.getMeasures();
        this.codec = new MeasureCodec(measuresDescs);
        this.aggs = new MeasureAggregators(measuresDescs);
        this.input = new Object[measuresDescs.size()];
        this.result = new Object[measuresDescs.size()];
        this.outputKey = new Text();
        this.outputValue = new Text();
        this.valueBuf = ByteBuffer.allocate(0x100000);
    }

    public void reduce(ByteArrayWritable key, Iterable<ByteArrayWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        this.aggs.reset();
        for (ByteArrayWritable value : values) {
            this.codec.decode(value.asBuffer(), this.input);
            this.aggs.aggregate(this.input);
        }
        this.aggs.collectStates(this.result);
        this.outputKey.set(key.array(), key.offset(), key.length());
        this.valueBuf.clear();
        this.codec.encode(this.result, this.valueBuf);
        this.outputValue.set(this.valueBuf.array(), 0, this.valueBuf.position());
        context.write((Object)this.outputKey, (Object)this.outputValue);
        ++this.counter;
        if (this.counter % 100000 == 0) {
            logger.info("Handled " + this.counter + " records!");
        }
    }
}

