/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidReducer;
import org.apache.kylin.job.manager.ExecutableManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(InMemCuboidJob.class);
    private boolean skipped = false;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        this.skipped = !cubingJob.isInMemCubing();
        return this.skipped;
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBING_JOB_ID);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            String output = this.getOptionValue(OPTION_OUTPUT_PATH);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(config);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            config = cube.getConfig();
            CubeSegment cubeSeg = cube.getSegment(segmentName, SegmentStatusEnum.NEW);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            if (this.checkSkip(cubingJobId)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + cubeSeg);
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job);
            this.attachKylinPropsAndMetadata(cube, this.job.getConfiguration());
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
            this.job.setMapperClass(InMemCuboidMapper.class);
            this.job.setMapOutputKeyClass(ByteArrayWritable.class);
            this.job.setMapOutputValueClass(ByteArrayWritable.class);
            this.job.setReducerClass(InMemCuboidReducer.class);
            this.job.setNumReduceTasks(this.calculateReducerNum(cubeSeg));
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            Path outputPath = new Path(output);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
            HadoopUtil.deletePath(this.job.getConfiguration(), outputPath);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CuboidJob", (Throwable)e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private int calculateReducerNum(CubeSegment cubeSeg) throws IOException {
        KylinConfig kylinConfig = cubeSeg.getConfig();
        Map<Long, Double> cubeSizeMap = new CubeStatsReader(cubeSeg, kylinConfig).getCuboidSizeMap();
        double totalSizeInM = 0.0;
        for (Double cuboidSize : cubeSizeMap.values()) {
            totalSizeInM += cuboidSize.doubleValue();
        }
        double perReduceInputMB = kylinConfig.getDefaultHadoopJobReducerInputMB();
        int numReduceTasks = (int)Math.round(totalSizeInM / perReduceInputMB);
        numReduceTasks = Math.max(1, numReduceTasks);
        numReduceTasks = Math.min(kylinConfig.getHadoopJobMaxReducerNumber(), numReduceTasks);
        logger.info("Having total map input MB " + Math.round(totalSizeInM));
        logger.info("Having per reduce MB " + perReduceInputMB);
        logger.info("Setting mapred.reduce.tasks=" + numReduceTasks);
        return numReduceTasks;
    }

    public static void main(String[] args) throws Exception {
        InMemCuboidJob job = new InMemCuboidJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

