/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidCLI;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.job.manager.ExecutableManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CuboidJob.class);
    private static final String MAPRED_REDUCE_TASKS = "mapred.reduce.tasks";
    private Class<? extends Mapper> mapperClass;
    private boolean skipped = false;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        this.skipped = !cubingJob.isLayerCubing();
        return this.skipped;
    }

    public int run(String[] args) throws Exception {
        if (this.mapperClass == null) {
            throw new Exception("Mapper class is not set!");
        }
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_NCUBOID_LEVEL);
            options.addOption(OPTION_INPUT_FORMAT);
            options.addOption(OPTION_CUBING_JOB_ID);
            this.parseOptions(options, args);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            int nCuboidLevel = Integer.parseInt(this.getOptionValue(OPTION_NCUBOID_LEVEL));
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(config);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            if (this.checkSkip(cubingJobId)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + cubeName + "[" + segmentName + "]");
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job);
            this.configureMapperInputFormat(cube.getSegment(segmentName, SegmentStatusEnum.NEW));
            this.job.setMapperClass(this.mapperClass);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setCombinerClass(CuboidReducer.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            this.job.getConfiguration().setInt("cube.cuboid.level", nCuboidLevel);
            this.attachKylinPropsAndMetadata(cube, this.job.getConfiguration());
            this.setReduceTaskNum(this.job, config, cubeName, nCuboidLevel);
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CuboidJob", (Throwable)e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void configureMapperInputFormat(CubeSegment cubeSeg) throws IOException {
        String input = this.getOptionValue(OPTION_INPUT_PATH);
        if ("FLAT_TABLE".equals(input)) {
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
        } else {
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{new Path(input)});
            if (this.hasOption(OPTION_INPUT_FORMAT) && "textinputformat".equalsIgnoreCase(this.getOptionValue(OPTION_INPUT_FORMAT))) {
                this.job.setInputFormatClass(TextInputFormat.class);
            } else {
                this.job.setInputFormatClass(SequenceFileInputFormat.class);
            }
        }
    }

    protected void setReduceTaskNum(Job job, KylinConfig config, String cubeName, int level) throws ClassNotFoundException, IOException, InterruptedException, JobException {
        int preLevelCuboids;
        int thisLevelCuboids;
        Configuration jobConf = job.getConfiguration();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeDesc cubeDesc = CubeManager.getInstance(config).getCube(cubeName).getDescriptor();
        kylinConfig = cubeDesc.getConfig();
        double perReduceInputMB = kylinConfig.getDefaultHadoopJobReducerInputMB();
        double reduceCountRatio = kylinConfig.getDefaultHadoopJobReducerCountRatio();
        double totalMapInputMB = this.getTotalMapInputMB();
        if (level == 0) {
            thisLevelCuboids = 1;
            preLevelCuboids = 1;
        } else {
            int[] allLevelCount = CuboidCLI.calculateAllLevelCount(cubeDesc);
            preLevelCuboids = allLevelCount[level - 1];
            thisLevelCuboids = allLevelCount[level];
        }
        double totalReduceInputMB = totalMapInputMB * (double)thisLevelCuboids / (double)preLevelCuboids;
        int numReduceTasks = (int)Math.round(totalReduceInputMB / perReduceInputMB * reduceCountRatio);
        if (cubeDesc.hasMemoryHungryMeasures()) {
            numReduceTasks *= 4;
        }
        numReduceTasks = Math.max(1, numReduceTasks);
        numReduceTasks = Math.min(kylinConfig.getHadoopJobMaxReducerNumber(), numReduceTasks);
        jobConf.setInt(MAPRED_REDUCE_TASKS, numReduceTasks);
        logger.info("Having total map input MB " + Math.round(totalMapInputMB));
        logger.info("Having level " + level + ", pre-level cuboids " + preLevelCuboids + ", this level cuboids " + thisLevelCuboids);
        logger.info("Having per reduce MB " + perReduceInputMB + ", reduce count ratio " + reduceCountRatio);
        logger.info("Setting mapred.reduce.tasks=" + numReduceTasks);
    }

    public void setMapperClass(Class<? extends Mapper> mapperClass) {
        this.mapperClass = mapperClass;
    }
}

