/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.commons.cli.Options;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.cli.DictionaryGeneratorCLI;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.engine.mr.DFSFileTable;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.ReadableTable;

public class CreateDictionaryJob
extends AbstractHadoopJob {
    private int returnCode = 0;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_INPUT_PATH);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            final String factColumnsInputPath = this.getOptionValue(OPTION_INPUT_PATH);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            DictionaryGeneratorCLI.processSegment(config, cubeName, segmentName, new DistinctColumnValuesProvider(){

                @Override
                public ReadableTable getDistinctValuesFor(TblColRef col) {
                    return new DFSFileTable(factColumnsInputPath + "/" + col.getName(), -1);
                }
            });
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
        return this.returnCode;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CreateDictionaryJob(), (String[])args);
        System.exit(exitCode);
    }
}

