/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.SegmentStatusEnum;

public class UpdateIIInfoAfterBuildStep
extends AbstractExecutable {
    private static final String II_NAME = "iiName";
    private static final String JOB_ID = "jobId";

    public void setInvertedIndexName(String cubeName) {
        this.setParam(II_NAME, cubeName);
    }

    private String getInvertedIndexName() {
        return this.getParam(II_NAME);
    }

    public void setJobId(String id) {
        this.setParam(JOB_ID, id);
    }

    private String getJobId() {
        return this.getParam(JOB_ID);
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        IIManager mgr = IIManager.getInstance(KylinConfig.getInstanceFromEnv());
        IIInstance ii = mgr.getII(this.getInvertedIndexName());
        IISegment segment = ii.getFirstSegment();
        segment.setStatus(SegmentStatusEnum.READY);
        segment.setLastBuildJobID(this.getJobId());
        segment.setLastBuildTime(System.currentTimeMillis());
        try {
            mgr.updateII(ii);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, "succeed");
        }
        catch (IOException e) {
            logger.error("fail to update inverted index after build", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }
}

