/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kylin.invertedindex.IISegment;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.DefaultChainedExecutable;

public class IIJob
extends DefaultChainedExecutable {
    private static final String II_INSTANCE_NAME = "iiName";
    private static final String SEGMENT_ID = "segmentId";

    void setIIName(String name) {
        this.setParam(II_INSTANCE_NAME, name);
    }

    public String getIIName() {
        return this.getParam(II_INSTANCE_NAME);
    }

    void setSegmentId(String segmentId) {
        this.setParam(SEGMENT_ID, segmentId);
    }

    public String getSegmentId() {
        return this.getParam(SEGMENT_ID);
    }

    public static IIJob createBuildJob(IISegment seg, String submitter, JobEngineConfig config) {
        return IIJob.initialJob(seg, "BUILD", submitter, config);
    }

    private static IIJob initialJob(IISegment seg, String type, String submitter, JobEngineConfig config) {
        IIJob result = new IIJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone(config.getTimeZone()));
        result.setIIName(seg.getIIInstance().getName());
        result.setSegmentId(seg.getUuid());
        result.setName(seg.getIIInstance().getName() + " - " + seg.getName() + " - " + type + " - " + format.format(new Date(System.currentTimeMillis())));
        result.setSubmitter(submitter);
        return result;
    }
}

