/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.invertedindex;

import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.invertedindex.IIJob;
import org.apache.kylin.engine.mr.invertedindex.InvertedIndexJob;
import org.apache.kylin.invertedindex.IISegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchIIJobBuilder
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchIIJobBuilder.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput.IMRBatchInvertedIndexingOutputSide outputSide;

    public BatchIIJobBuilder(IISegment newSegment, String submitter) {
        super(newSegment, submitter);
        this.inputSide = MRUtil.getBatchCubingInputSide(newSegment);
        this.outputSide = MRUtil.getBatchInvertedIndexingOutputSide(newSegment);
    }

    public IIJob build() {
        logger.info("MR new job to BUILD segment " + this.seg);
        IIJob result = IIJob.createBuildJob((IISegment)this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String iiRootPath = this.getRealizationRootPath(jobId) + "/";
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        result.addTask(this.createInvertedIndexStep((IISegment)this.seg, iiRootPath));
        this.outputSide.addStepPhase3_BuildII(result, iiRootPath);
        result.addTask(this.createUpdateIIInfoAfterBuildStep(jobId));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    private MapReduceExecutable createInvertedIndexStep(IISegment seg, String iiOutputTempPath) {
        MapReduceExecutable buildIIStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, seg.getRealization().getDataModelDesc());
        buildIIStep.setName("Build Inverted Index");
        BatchIIJobBuilder.appendExecCmdParameters(cmd, "iiname", seg.getRealization().getName());
        BatchIIJobBuilder.appendExecCmdParameters(cmd, "output", iiOutputTempPath);
        BatchIIJobBuilder.appendExecCmdParameters(cmd, "jobname", "Build Inverted Index");
        buildIIStep.setMapReduceParams(cmd.toString());
        buildIIStep.setMapReduceJobClass(InvertedIndexJob.class);
        return buildIIStep;
    }
}

