/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.kylin.engine.mr.common.HadoopStatusGetter;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStatusChecker {
    protected static final Logger logger = LoggerFactory.getLogger(HadoopStatusChecker.class);
    private final String yarnUrl;
    private final String mrJobID;
    private final StringBuilder output;
    private final boolean useKerberosAuth;

    public HadoopStatusChecker(String yarnUrl, String mrJobID, StringBuilder output, boolean useKerberosAuth) {
        this.yarnUrl = yarnUrl;
        this.mrJobID = mrJobID;
        this.output = output;
        this.useKerberosAuth = useKerberosAuth;
    }

    public JobStepStatusEnum checkStatus() {
        if (null == this.mrJobID) {
            this.output.append("Skip status check with empty job id..\n");
            return JobStepStatusEnum.WAITING;
        }
        JobStepStatusEnum status = null;
        try {
            Pair<RMAppState, FinalApplicationStatus> result = new HadoopStatusGetter(this.yarnUrl, this.mrJobID).get(this.useKerberosAuth);
            logger.debug("State of Hadoop job: " + this.mrJobID + ":" + result.getLeft() + "-" + result.getRight());
            this.output.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format(new Date()) + " - State of Hadoop job: " + this.mrJobID + ":" + result.getLeft() + " - " + result.getRight() + "\n");
            block1 : switch ((FinalApplicationStatus)result.getRight()) {
                case SUCCEEDED: {
                    status = JobStepStatusEnum.FINISHED;
                    break;
                }
                case FAILED: {
                    status = JobStepStatusEnum.ERROR;
                    break;
                }
                case KILLED: {
                    status = JobStepStatusEnum.KILLED;
                    break;
                }
                case UNDEFINED: {
                    switch ((RMAppState)result.getLeft()) {
                        case NEW: 
                        case NEW_SAVING: 
                        case SUBMITTED: 
                        case ACCEPTED: {
                            status = JobStepStatusEnum.WAITING;
                            break block1;
                        }
                        case RUNNING: {
                            status = JobStepStatusEnum.RUNNING;
                            break block1;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("error check status", (Throwable)e);
            this.output.append("Exception: " + e.getLocalizedMessage() + "\n");
            status = JobStepStatusEnum.ERROR;
        }
        return status;
    }
}

