/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;

public class HadoopShellExecutable
extends AbstractExecutable {
    private static final String KEY_MR_JOB = "HADOOP_SHELL_JOB_CLASS";
    private static final String KEY_PARAMS = "HADOOP_SHELL_JOB_PARAMS";

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String mapReduceJobClass = this.getJobClass();
        String params = this.getJobParams();
        Preconditions.checkNotNull((Object)mapReduceJobClass);
        Preconditions.checkNotNull((Object)params);
        try {
            int result;
            Constructor<AbstractHadoopJob> constructor = ClassUtil.forName(mapReduceJobClass, AbstractHadoopJob.class).getConstructor(new Class[0]);
            AbstractHadoopJob job = constructor.newInstance(new Object[0]);
            String[] args = params.trim().split("\\s+");
            logger.info("parameters of the HadoopShellExecutable:");
            logger.info(params);
            StringBuilder log = new StringBuilder();
            try {
                result = ToolRunner.run((Tool)job, (String[])args);
            }
            catch (Exception ex) {
                logger.error("error execute " + this.toString(), (Throwable)ex);
                StringWriter stringWriter = new StringWriter();
                ex.printStackTrace(new PrintWriter(stringWriter));
                log.append(stringWriter.toString()).append("\n");
                result = 2;
            }
            log.append("result code:").append(result);
            return result == 0 ? new ExecuteResult(ExecuteResult.State.SUCCEED, log.toString()) : new ExecuteResult(ExecuteResult.State.FAILED, log.toString());
        }
        catch (ReflectiveOperationException e) {
            logger.error("error getMapReduceJobClass, class name:" + this.getParam(KEY_MR_JOB), (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.error("error execute " + this.toString(), (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    public void setJobClass(Class<? extends AbstractHadoopJob> clazzName) {
        this.setParam(KEY_MR_JOB, clazzName.getName());
    }

    public String getJobClass() throws ExecuteException {
        return this.getParam(KEY_MR_JOB);
    }

    public void setJobParams(String param) {
        this.setParam(KEY_PARAMS, param);
    }

    public String getJobParams() {
        return this.getParam(KEY_PARAMS);
    }
}

