/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.SumHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeStatsReader {
    private static final Logger logger = LoggerFactory.getLogger(CubeStatsReader.class);
    final CubeSegment seg;
    final int samplingPercentage;
    final double mapperOverlapRatioOfFirstBuild;
    final Map<Long, HyperLogLogPlusCounter> cuboidRowEstimatesHLL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubeStatsReader(CubeSegment cubeSegment, KylinConfig kylinConfig) throws IOException {
        ResourceStore store = ResourceStore.getStore(kylinConfig);
        String statsKey = cubeSegment.getStatisticsResourcePath();
        File tmpSeqFile = this.writeTmpSeqFile(store.getResource((String)statsKey).inputStream);
        SequenceFile.Reader reader = null;
        try {
            Configuration hadoopConf = HadoopUtil.getCurrentConfiguration();
            Path path = new Path(HadoopUtil.fixWindowsPath("file://" + tmpSeqFile.getAbsolutePath()));
            SequenceFile.Reader.Option seqInput = SequenceFile.Reader.file((Path)path);
            reader = new SequenceFile.Reader(hadoopConf, new SequenceFile.Reader.Option[]{seqInput});
            int percentage = 100;
            double mapperOverlapRatio = 0.0;
            HashMap counterMap = Maps.newHashMap();
            LongWritable key = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)hadoopConf);
            BytesWritable value = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)hadoopConf);
            while (reader.next((Writable)key, (Writable)value)) {
                if (key.get() == 0L) {
                    percentage = Bytes.toInt(value.getBytes());
                    continue;
                }
                if (key.get() == -1L) {
                    mapperOverlapRatio = Bytes.toDouble(value.getBytes());
                    continue;
                }
                HyperLogLogPlusCounter hll = new HyperLogLogPlusCounter(kylinConfig.getCubeStatsHLLPrecision());
                ByteArray byteArray = new ByteArray(value.getBytes());
                hll.readRegisters(byteArray.asBuffer());
                counterMap.put(key.get(), hll);
            }
            this.seg = cubeSegment;
            this.samplingPercentage = percentage;
            this.mapperOverlapRatioOfFirstBuild = mapperOverlapRatio;
            this.cuboidRowEstimatesHLL = counterMap;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(reader);
            tmpSeqFile.delete();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)reader);
        tmpSeqFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeTmpSeqFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("kylin_stats_tmp", ".seq");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            org.apache.commons.io.IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        finally {
            IOUtils.closeStream((Closeable)inputStream);
            IOUtils.closeStream((Closeable)out);
        }
        return tempFile;
    }

    public Map<Long, Long> getCuboidRowEstimatesHLL() {
        return CubeStatsReader.getCuboidRowCountMapFromSampling(this.cuboidRowEstimatesHLL, this.samplingPercentage);
    }

    public Map<Long, Double> getCuboidSizeMap() {
        return CubeStatsReader.getCuboidSizeMapFromRowCount(this.seg, this.getCuboidRowEstimatesHLL());
    }

    public double getMapperOverlapRatioOfFirstBuild() {
        return this.mapperOverlapRatioOfFirstBuild;
    }

    public static Map<Long, Long> getCuboidRowCountMapFromSampling(Map<Long, HyperLogLogPlusCounter> hllcMap, int samplingPercentage) {
        HashMap cuboidRowCountMap = Maps.newHashMap();
        for (Map.Entry<Long, HyperLogLogPlusCounter> entry : hllcMap.entrySet()) {
            cuboidRowCountMap.put(entry.getKey(), entry.getValue().getCountEstimate());
        }
        return cuboidRowCountMap;
    }

    public static Map<Long, Double> getCuboidSizeMapFromRowCount(CubeSegment cubeSegment, Map<Long, Long> rowCountMap) {
        CubeDesc cubeDesc = cubeSegment.getCubeDesc();
        ArrayList rowkeyColumnSize = Lists.newArrayList();
        long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
        Cuboid baseCuboid = Cuboid.findById(cubeDesc, baseCuboidId);
        List<TblColRef> columnList = baseCuboid.getColumns();
        CubeDimEncMap dimEncMap = cubeSegment.getDimensionEncodingMap();
        for (int i = 0; i < columnList.size(); ++i) {
            rowkeyColumnSize.add(dimEncMap.get(columnList.get(i)).getLengthOfEncoding());
        }
        HashMap sizeMap = Maps.newHashMap();
        for (Map.Entry<Long, Long> entry : rowCountMap.entrySet()) {
            sizeMap.put(entry.getKey(), CubeStatsReader.estimateCuboidStorageSize(cubeSegment, entry.getKey(), entry.getValue(), baseCuboidId, rowkeyColumnSize));
        }
        return sizeMap;
    }

    private static double estimateCuboidStorageSize(CubeSegment cubeSegment, long cuboidId, long rowCount, long baseCuboidId, List<Integer> rowKeyColumnLength) {
        int bytesLength = cubeSegment.getRowKeyPreambleSize();
        long mask = Long.highestOneBit(baseCuboidId);
        long parentCuboidIdActualLength = 64 - Long.numberOfLeadingZeros(baseCuboidId);
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & cuboidId) > 0L) {
                bytesLength += rowKeyColumnLength.get(i).intValue();
            }
            mask >>= 1;
            ++i;
        }
        int space = 0;
        boolean isMemoryHungry = false;
        for (MeasureDesc measureDesc : cubeSegment.getCubeDesc().getMeasures()) {
            if (measureDesc.getFunction().getMeasureType().isMemoryHungry()) {
                isMemoryHungry = true;
            }
            DataType returnType = measureDesc.getFunction().getReturnDataType();
            space += returnType.getStorageBytesEstimate();
        }
        double ret = 1.0 * (double)(bytesLength += space) * (double)rowCount / 1048576.0;
        if (isMemoryHungry) {
            logger.info("Cube is memory hungry, storage size estimation multiply 0.05");
            ret *= 0.05;
        } else {
            logger.info("Cube is not memory hungry, storage size estimation multiply 0.25");
            ret *= 0.25;
        }
        logger.info("Cuboid " + cuboidId + " has " + rowCount + " rows, each row size is " + bytesLength + " bytes." + " Total size is " + ret + "M.");
        return ret;
    }

    private void print(PrintWriter out) {
        Map<Long, Long> cuboidRows = this.getCuboidRowEstimatesHLL();
        Map<Long, Double> cuboidSizes = this.getCuboidSizeMap();
        ArrayList<Long> cuboids = new ArrayList<Long>(cuboidRows.keySet());
        Collections.sort(cuboids);
        out.println("============================================================================");
        out.println("Statistics of " + this.seg);
        out.println();
        out.println("Cube statistics hll precision: " + this.cuboidRowEstimatesHLL.values().iterator().next().getPrecision());
        out.println("Total cuboids: " + cuboidRows.size());
        out.println("Total estimated rows: " + SumHelper.sumLong(cuboidRows.values()));
        out.println("Total estimated size(MB): " + SumHelper.sumDouble(cuboidSizes.values()));
        out.println("Sampling percentage:  " + this.samplingPercentage);
        out.println("Mapper overlap ratio: " + this.mapperOverlapRatioOfFirstBuild);
        this.printCuboidInfoTreeEntry(cuboidRows, cuboidSizes, out);
        out.println("----------------------------------------------------------------------------");
    }

    private void printCuboidInfoTreeEntry(Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, PrintWriter out) {
        CubeDesc cubeDesc = this.seg.getCubeDesc();
        CuboidScheduler scheduler = new CuboidScheduler(cubeDesc);
        long baseCuboid = Cuboid.getBaseCuboidId(cubeDesc);
        int dimensionCount = Long.bitCount(baseCuboid);
        CubeStatsReader.printCuboidInfoTree(-1L, baseCuboid, scheduler, cuboidRows, cuboidSizes, dimensionCount, 0, out);
    }

    private static void printCuboidInfoTree(long parent, long cuboidID, CuboidScheduler scheduler, Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, int dimensionCount, int depth, PrintWriter out) {
        CubeStatsReader.printOneCuboidInfo(parent, cuboidID, cuboidRows, cuboidSizes, dimensionCount, depth, out);
        List<Long> children = scheduler.getSpanningCuboid(cuboidID);
        Collections.sort(children);
        for (Long child : children) {
            CubeStatsReader.printCuboidInfoTree(cuboidID, child, scheduler, cuboidRows, cuboidSizes, dimensionCount, depth + 1, out);
        }
    }

    private static void printOneCuboidInfo(long parent, long cuboidID, Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, int dimensionCount, int depth, PrintWriter out) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        String cuboidName = Cuboid.getDisplayName(cuboidID, dimensionCount);
        sb.append("|---- Cuboid ").append(cuboidName);
        long rowCount = cuboidRows.get(cuboidID);
        double size = cuboidSizes.get(cuboidID);
        sb.append(", est row: ").append(rowCount).append(", est MB: ").append(CubeStatsReader.formatDouble(size));
        if (parent != -1L) {
            sb.append(", shrink: ").append(CubeStatsReader.formatDouble(100.0 * (double)cuboidRows.get(cuboidID).longValue() / (double)cuboidRows.get(parent).longValue())).append("%");
        }
        out.println(sb.toString());
    }

    private static String formatDouble(double input) {
        return new DecimalFormat("#.##").format(input);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("CubeStatsReader is used to read cube statistic saved in metadata store");
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CubeInstance cube = CubeManager.getInstance(config).getCube(args[0]);
        List<CubeSegment> segments = cube.getSegments(SegmentStatusEnum.READY);
        PrintWriter out = new PrintWriter(System.out);
        for (CubeSegment seg : segments) {
            new CubeStatsReader(seg, config).print(out);
        }
        out.flush();
    }
}

