/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopJob
extends Configured
implements Tool {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractHadoopJob.class);
    protected static final Option OPTION_JOB_NAME;
    protected static final Option OPTION_CUBE_NAME;
    protected static final Option OPTION_CUBING_JOB_ID;
    protected static final Option OPTION_II_NAME;
    protected static final Option OPTION_SEGMENT_NAME;
    protected static final Option OPTION_INPUT_PATH;
    protected static final Option OPTION_INPUT_FORMAT;
    protected static final Option OPTION_OUTPUT_PATH;
    protected static final Option OPTION_NCUBOID_LEVEL;
    protected static final Option OPTION_PARTITION_FILE_PATH;
    protected static final Option OPTION_HTABLE_NAME;
    protected static final Option OPTION_STATISTICS_ENABLED;
    protected static final Option OPTION_STATISTICS_OUTPUT;
    protected static final Option OPTION_STATISTICS_SAMPLING_PERCENT;
    private static final String MAP_REDUCE_CLASSPATH = "mapreduce.application.classpath";
    private static final String KYLIN_HIVE_DEPENDENCY_JARS = "[^,]*hive-exec[0-9.-]+[^,]*?\\.jar|[^,]*hive-metastore[0-9.-]+[^,]*?\\.jar|[^,]*hive-hcatalog-core[0-9.-]+[^,]*?\\.jar";
    protected String name;
    protected boolean isAsync = false;
    protected OptionsHelper optionsHelper = new OptionsHelper();
    protected Job job;

    protected static void runJob(Tool job, String[] args) {
        try {
            int exitCode = ToolRunner.run((Tool)job, (String[])args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(5);
        }
    }

    public AbstractHadoopJob() {
        super(HadoopUtil.getCurrentConfiguration());
    }

    protected void parseOptions(Options options, String[] args) throws ParseException {
        this.optionsHelper.parseOptions(options, args);
    }

    public void printUsage(Options options) {
        this.optionsHelper.printUsage(((Object)((Object)this)).getClass().getSimpleName(), options);
    }

    public Option[] getOptions() {
        return this.optionsHelper.getOptions();
    }

    public String getOptionsAsString() {
        return this.optionsHelper.getOptionsAsString();
    }

    protected String getOptionValue(Option option) {
        return this.optionsHelper.getOptionValue(option);
    }

    protected boolean hasOption(Option option) {
        return this.optionsHelper.hasOption(option);
    }

    protected int waitForCompletion(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        int retVal = 0;
        long start = System.nanoTime();
        if (this.isAsync) {
            job.submit();
        } else {
            job.waitForCompletion(true);
            retVal = job.isSuccessful() ? 0 : 1;
            logger.debug("Job '" + job.getJobName() + "' finished " + (job.isSuccessful() ? "successfully in " : "with failures.  Time taken ") + org.apache.hadoop.util.StringUtils.formatTime((long)((System.nanoTime() - start) / 1000000L)));
        }
        return retVal;
    }

    protected void setJobClasspath(Job job) {
        String jarPath = KylinConfig.getInstanceFromEnv().getKylinJobJarPath();
        File jarFile = new File(jarPath);
        if (jarFile.exists()) {
            job.setJar(jarPath);
            logger.info("append job jar: " + jarPath);
        } else {
            job.setJarByClass(((Object)((Object)this)).getClass());
        }
        String kylinHiveDependency = System.getProperty("kylin.hive.dependency");
        String kylinHBaseDependency = System.getProperty("kylin.hbase.dependency");
        logger.info("append kylin.hbase.dependency: " + kylinHBaseDependency + " to " + MAP_REDUCE_CLASSPATH);
        Configuration jobConf = job.getConfiguration();
        String classpath = jobConf.get(MAP_REDUCE_CLASSPATH);
        if (classpath == null || classpath.length() == 0) {
            logger.info("Didn't find mapreduce.application.classpath in job configuration, will run 'mapred classpath' to get the default value.");
            classpath = this.getDefaultMapRedClasspath();
            logger.info("The default mapred classpath is: " + classpath);
        }
        if (kylinHBaseDependency != null) {
            kylinHBaseDependency = kylinHBaseDependency.replace(":", ",");
            classpath = classpath + "," + kylinHBaseDependency;
        }
        jobConf.set(MAP_REDUCE_CLASSPATH, classpath);
        logger.info("Hadoop job classpath is: " + job.getConfiguration().get(MAP_REDUCE_CLASSPATH));
        StringBuilder kylinDependency = new StringBuilder();
        if (kylinHiveDependency != null) {
            kylinHiveDependency = kylinHiveDependency.replace(":", ",");
            logger.info("Hive Dependencies Before Filtered: " + kylinHiveDependency);
            String filteredHive = this.filterKylinHiveDependency(kylinHiveDependency);
            logger.info("Hive Dependencies After Filtered: " + filteredHive);
            if (kylinDependency.length() > 0) {
                kylinDependency.append(",");
            }
            kylinDependency.append(filteredHive);
        } else {
            logger.info("No hive dependency jars set in the environment, will find them from jvm:");
            try {
                String hiveExecJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.ql.Driver"));
                kylinDependency.append(hiveExecJarPath).append(",");
                logger.info("hive-exec jar file: " + hiveExecJarPath);
                String hiveHCatJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hive.hcatalog.mapreduce.HCatInputFormat"));
                kylinDependency.append(hiveHCatJarPath).append(",");
                logger.info("hive-catalog jar file: " + hiveHCatJarPath);
                String hiveMetaStoreJarPath = ClassUtil.findContainingJar(Class.forName("org.apache.hadoop.hive.metastore.api.Table"));
                kylinDependency.append(hiveMetaStoreJarPath).append(",");
                logger.info("hive-metastore jar file: " + hiveMetaStoreJarPath);
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot found hive dependency jars: " + e);
            }
        }
        String mrLibDir = KylinConfig.getInstanceFromEnv().getKylinJobMRLibDir();
        if (!StringUtils.isBlank((String)mrLibDir)) {
            File dirFileMRLIB = new File(mrLibDir);
            if (dirFileMRLIB.exists()) {
                if (kylinDependency.length() > 0) {
                    kylinDependency.append(",");
                }
                kylinDependency.append(mrLibDir);
            } else {
                logger.info("The directory '" + mrLibDir + "' for 'kylin.job.mr.lib.dir' does not exist!!!");
            }
        }
        this.setJobTmpJarsAndFiles(job, kylinDependency.toString());
    }

    private String filterKylinHiveDependency(String kylinHiveDependency) {
        if (StringUtils.isBlank((String)kylinHiveDependency)) {
            return "";
        }
        StringBuilder jarList = new StringBuilder();
        Pattern hivePattern = Pattern.compile(KYLIN_HIVE_DEPENDENCY_JARS);
        Matcher matcher = hivePattern.matcher(kylinHiveDependency);
        while (matcher.find()) {
            if (jarList.length() > 0) {
                jarList.append(",");
            }
            jarList.append(matcher.group());
        }
        return jarList.toString();
    }

    private void setJobTmpJarsAndFiles(Job job, String kylinDependency) {
        if (StringUtils.isBlank((String)kylinDependency)) {
            return;
        }
        String[] fNameList = kylinDependency.split(",");
        try {
            Configuration jobConf = job.getConfiguration();
            LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
            StringBuilder jarList = new StringBuilder();
            StringBuilder fileList = new StringBuilder();
            for (String fileName : fNameList) {
                StringBuilder list;
                Path p = new Path(fileName);
                if (fs.getFileStatus(p).isDirectory()) {
                    this.appendTmpDir(job, fileName);
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath().toString());
            }
            this.appendTmpFiles(fileList.toString(), jobConf);
            this.appendTmpJars(jarList.toString(), jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpDir(Job job, String tmpDir) {
        if (StringUtils.isBlank((String)tmpDir)) {
            return;
        }
        try {
            Configuration jobConf = job.getConfiguration();
            LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
            FileStatus[] fList = fs.listStatus(new Path(tmpDir));
            StringBuilder jarList = new StringBuilder();
            StringBuilder fileList = new StringBuilder();
            for (FileStatus file : fList) {
                StringBuilder list;
                Path p = file.getPath();
                if (fs.getFileStatus(p).isDirectory()) {
                    this.appendTmpDir(job, p.toString());
                    continue;
                }
                StringBuilder stringBuilder = list = p.getName().endsWith(".jar") ? jarList : fileList;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(fs.getFileStatus(p).getPath().toString());
            }
            this.appendTmpFiles(fileList.toString(), jobConf);
            this.appendTmpJars(jarList.toString(), jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendTmpJars(String jarList, Configuration conf) {
        if (StringUtils.isBlank((String)jarList)) {
            return;
        }
        String tmpJars = conf.get("tmpjars", null);
        tmpJars = tmpJars == null ? jarList : tmpJars + "," + jarList;
        conf.set("tmpjars", tmpJars);
        logger.info("Job 'tmpjars' updated -- " + tmpJars);
    }

    private void appendTmpFiles(String fileList, Configuration conf) {
        if (StringUtils.isBlank((String)fileList)) {
            return;
        }
        String tmpFiles = conf.get("tmpfiles", null);
        tmpFiles = tmpFiles == null ? fileList : tmpFiles + "," + fileList;
        conf.set("tmpfiles", tmpFiles);
        logger.info("Job 'tmpfiles' updated -- " + tmpFiles);
    }

    private String getDefaultMapRedClasspath() {
        String classpath = "";
        try {
            CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
            String output = executor.execute("mapred classpath").getSecond();
            classpath = output.trim().replace(':', ',');
        }
        catch (IOException e) {
            logger.error("Failed to run: 'mapred classpath'.", (Throwable)e);
        }
        return classpath;
    }

    public static void addInputDirs(String input, Job job) throws IOException {
        AbstractHadoopJob.addInputDirs(StringSplitter.split(input, ","), job);
    }

    public static void addInputDirs(String[] inputs, Job job) throws IOException {
        for (String inp : inputs) {
            if ((inp = inp.trim()).endsWith("/*")) {
                inp = inp.substring(0, inp.length() - 2);
                FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
                Path path = new Path(inp);
                FileStatus[] fileStatuses = fs.listStatus(path);
                boolean hasDir = false;
                for (FileStatus stat : fileStatuses) {
                    if (!stat.isDirectory() || stat.getPath().getName().startsWith("_")) continue;
                    hasDir = true;
                    AbstractHadoopJob.addInputDirs(stat.getPath().toString(), job);
                }
                if (fileStatuses.length <= 0 || hasDir) continue;
                AbstractHadoopJob.addInputDirs(path.toString(), job);
                continue;
            }
            logger.debug("Add input " + inp);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inp));
        }
    }

    public static KylinConfig loadKylinPropsAndMetadata() throws IOException {
        File metaDir = new File("meta");
        if (!metaDir.getAbsolutePath().equals(System.getProperty("KYLIN_CONF"))) {
            System.setProperty("KYLIN_CONF", metaDir.getAbsolutePath());
            logger.info("The absolute path for meta dir is " + metaDir.getAbsolutePath());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            kylinConfig.setMetadataUrl(metaDir.getAbsolutePath());
            return kylinConfig;
        }
        return KylinConfig.getInstanceFromEnv();
    }

    protected void attachKylinPropsAndMetadata(TableDesc table, Configuration conf) throws IOException {
        ArrayList<String> dumpList = new ArrayList<String>();
        dumpList.add(table.getResourcePath());
        this.attachKylinPropsAndMetadata(dumpList, KylinConfig.getInstanceFromEnv(), conf);
    }

    protected void attachKylinPropsAndMetadata(CubeInstance cube, Configuration conf) throws IOException {
        MetadataManager metaMgr = MetadataManager.getInstance(cube.getConfig());
        ArrayList<String> dumpList = new ArrayList<String>();
        dumpList.add(cube.getResourcePath());
        dumpList.add(cube.getDescriptor().getModel().getResourcePath());
        dumpList.add(cube.getDescriptor().getResourcePath());
        for (String tableName : cube.getDescriptor().getModel().getAllTables()) {
            TableDesc table = metaMgr.getTableDesc(tableName);
            dumpList.add(table.getResourcePath());
        }
        for (CubeSegment segment : cube.getSegments()) {
            dumpList.addAll(segment.getDictionaryPaths());
        }
        this.attachKylinPropsAndMetadata(dumpList, cube.getConfig(), conf);
    }

    protected void attachKylinPropsAndMetadata(IIInstance ii, Configuration conf) throws IOException {
        MetadataManager metaMgr = MetadataManager.getInstance(ii.getConfig());
        ArrayList<String> dumpList = new ArrayList<String>();
        dumpList.add(ii.getResourcePath());
        dumpList.add(ii.getDescriptor().getModel().getResourcePath());
        dumpList.add(ii.getDescriptor().getResourcePath());
        for (String tableName : ii.getDescriptor().getModel().getAllTables()) {
            TableDesc table = metaMgr.getTableDesc(tableName);
            dumpList.add(table.getResourcePath());
        }
        this.attachKylinPropsAndMetadata(dumpList, ii.getConfig(), conf);
    }

    protected void attachKylinPropsAndMetadata(ArrayList<String> dumpList, KylinConfig kylinConfig, Configuration conf) throws IOException {
        File tmp = File.createTempFile("kylin_job_meta", "");
        FileUtils.forceDelete((File)tmp);
        File metaDir = new File(tmp, "meta");
        metaDir.mkdirs();
        File kylinPropsFile = new File(metaDir, "kylin.properties");
        kylinConfig.writeProperties(kylinPropsFile);
        this.dumpResources(kylinConfig, metaDir, dumpList);
        String hdfsMetaDir = OptionsHelper.convertToFileURL(metaDir.getAbsolutePath());
        hdfsMetaDir = hdfsMetaDir.startsWith("/") ? "file://" + hdfsMetaDir : "file:///" + hdfsMetaDir;
        logger.info("HDFS meta dir is: " + hdfsMetaDir);
        this.appendTmpFiles(hdfsMetaDir, conf);
    }

    protected void cleanupTempConfFile(Configuration conf) {
        String tempMetaFileString = conf.get("tmpfiles");
        logger.info("tempMetaFileString is : " + tempMetaFileString);
        if (tempMetaFileString != null) {
            if (tempMetaFileString.startsWith("file://")) {
                File tempMetaFile = new File(tempMetaFileString = tempMetaFileString.substring("file://".length()));
                if (tempMetaFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)tempMetaFile.getParentFile());
                    }
                    catch (IOException e) {
                        logger.warn("error when deleting " + tempMetaFile, (Throwable)e);
                    }
                } else {
                    logger.info("" + tempMetaFileString + " does not exist");
                }
            } else {
                logger.info("tempMetaFileString is not starting with file:// :" + tempMetaFileString);
            }
        }
    }

    private void dumpResources(KylinConfig kylinConfig, File metaDir, ArrayList<String> dumpList) throws IOException {
        ResourceStore from = ResourceStore.getStore(kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri(metaDir.getAbsolutePath());
        ResourceStore to = ResourceStore.getStore(localConfig);
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.inputStream, res.timestamp);
            res.inputStream.close();
        }
    }

    protected void deletePath(Configuration conf, Path path) throws IOException {
        HadoopUtil.deletePath(conf, path);
    }

    protected double getTotalMapInputMB() throws ClassNotFoundException, IOException, InterruptedException, JobException {
        if (this.job == null) {
            throw new JobException("Job is null");
        }
        long mapInputBytes = 0L;
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)this.job.getConfiguration());
        for (InputSplit split : input.getSplits((JobContext)this.job)) {
            mapInputBytes += split.getLength();
        }
        if (mapInputBytes == 0L) {
            throw new IllegalArgumentException("Map input splits are 0 bytes, something is wrong!");
        }
        double totalMapInputMB = (double)mapInputBytes / 1024.0 / 1024.0;
        return totalMapInputMB;
    }

    protected int getMapInputSplitCount() throws ClassNotFoundException, JobException, IOException, InterruptedException {
        if (this.job == null) {
            throw new JobException("Job is null");
        }
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)this.job.getConfiguration());
        return input.getSplits((JobContext)this.job).size();
    }

    public void kill() throws JobException {
        if (this.job != null) {
            try {
                this.job.killJob();
            }
            catch (IOException e) {
                throw new JobException(e);
            }
        }
    }

    public Map<String, String> getInfo() throws JobException {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        throw new JobException("Job is null");
    }

    public Counters getCounters() throws JobException {
        if (this.job != null) {
            try {
                return this.job.getCounters();
            }
            catch (IOException e) {
                throw new JobException(e);
            }
        }
        throw new JobException("Job is null");
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public Job getJob() {
        return this.job;
    }

    public boolean isSkipped() {
        return false;
    }

    static {
        OptionBuilder.withArgName((String)"jobname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Job name. For example, Kylin_Cuboid_Builder-clsfd_v2_Step_22-D)");
        OPTION_JOB_NAME = OptionBuilder.create((String)"jobname");
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube name. For exmaple, flat_item_cube");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"cubingJobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"ID of cubing job executable");
        OPTION_CUBING_JOB_ID = OptionBuilder.create((String)"cubingJobId");
        OptionBuilder.withArgName((String)"iiname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"II name. For exmaple, some_ii");
        OPTION_II_NAME = OptionBuilder.create((String)"iiname");
        OptionBuilder.withArgName((String)"segmentname");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube segment name");
        OPTION_SEGMENT_NAME = OptionBuilder.create((String)"segmentname");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Input path");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"inputformat");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Input format");
        OPTION_INPUT_FORMAT = OptionBuilder.create((String)"inputformat");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"N-Cuboid build level, e.g. 1, 2, 3...");
        OPTION_NCUBOID_LEVEL = OptionBuilder.create((String)"level");
        OptionBuilder.withArgName((String)"partitions");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Partition file path.");
        OPTION_PARTITION_FILE_PATH = OptionBuilder.create((String)"partitions");
        OptionBuilder.withArgName((String)"htablename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HTable name");
        OPTION_HTABLE_NAME = OptionBuilder.create((String)"htablename");
        OptionBuilder.withArgName((String)"statisticsenabled");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics enabled");
        OPTION_STATISTICS_ENABLED = OptionBuilder.create((String)"statisticsenabled");
        OptionBuilder.withArgName((String)"statisticsoutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics output");
        OPTION_STATISTICS_OUTPUT = OptionBuilder.create((String)"statisticsoutput");
        OptionBuilder.withArgName((String)"statisticssamplingpercent");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Statistics sampling percentage");
        OPTION_STATISTICS_SAMPLING_PERCENT = OptionBuilder.create((String)"statisticssamplingpercent");
    }
}

