/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public class HadoopUtil {
    private static final ThreadLocal<Configuration> hadoopConfig = new ThreadLocal();

    public static void setCurrentConfiguration(Configuration conf) {
        hadoopConfig.set(conf);
    }

    public static Configuration getCurrentConfiguration() {
        if (hadoopConfig.get() == null) {
            Configuration conf = HadoopUtil.healSickConfig(new Configuration());
            return conf;
        }
        return hadoopConfig.get();
    }

    private static Configuration healSickConfig(Configuration conf) {
        conf.set("dfs.client.block.write.locateFollowingBlock.retries", "8");
        if (StringUtils.isBlank((String)conf.get("hadoop.tmp.dir"))) {
            conf.set("hadoop.tmp.dir", "/tmp");
        }
        if (StringUtils.isBlank((String)conf.get("hbase.fs.tmp.dir"))) {
            conf.set("hbase.fs.tmp.dir", "/tmp");
        }
        return conf;
    }

    public static FileSystem getFileSystem(String path) throws IOException {
        return FileSystem.get((URI)HadoopUtil.makeURI(path), (Configuration)HadoopUtil.getCurrentConfiguration());
    }

    public static URI makeURI(String filePath) {
        try {
            return new URI(HadoopUtil.fixWindowsPath(filePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from URI: " + filePath, e);
        }
    }

    public static String fixWindowsPath(String path) {
        if (path.startsWith("file://") && !path.startsWith("file:///") && path.contains(":\\")) {
            path = path.replace("file://", "file:///");
        }
        if (path.startsWith("file:///")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String[] parseHiveTableName(String table) {
        int cut = table.indexOf(46);
        String database = cut >= 0 ? table.substring(0, cut).trim() : "DEFAULT";
        String tableName = cut >= 0 ? table.substring(cut + 1).trim() : table.trim();
        return new String[]{database, tableName};
    }

    public static void deletePath(Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    public static byte[] toBytes(Writable writable) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            writable.write((DataOutput)out);
            out.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

