/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;

public class CubingJob
extends DefaultChainedExecutable {
    public static final String SOURCE_RECORD_COUNT = "sourceRecordCount";
    public static final String SOURCE_SIZE_BYTES = "sourceSizeBytes";
    public static final String CUBE_SIZE_BYTES = "byteSizeBytes";
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final String DEPLOY_ENV_NAME = "envName";
    private static final String PROJECT_INSTANCE_NAME = "projectName";

    public static CubingJob createBuildJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, "BUILD", submitter, config);
    }

    public static CubingJob createMergeJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, "MERGE", submitter, config);
    }

    private static CubingJob initCubingJob(CubeSegment seg, String jobType, String submitter, JobEngineConfig config) {
        KylinConfig kylinConfig = config.getConfig();
        CubeInstance cube = seg.getCubeInstance();
        List<ProjectInstance> projList = ProjectManager.getInstance(kylinConfig).findProjects(cube.getType(), cube.getName());
        if (projList == null || projList.size() == 0) {
            throw new RuntimeException("Cannot find the project containing the cube " + cube.getName() + "!!!");
        }
        if (projList.size() >= 2) {
            throw new RuntimeException("Find more than one project containing the cube " + cube.getName() + ". It does't meet the uniqueness requirement!!! ");
        }
        CubingJob result = new CubingJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone(config.getTimeZone()));
        result.setDeployEnvName(kylinConfig.getDeployEnv());
        result.setProjectName(projList.get(0).getName());
        CubingExecutableUtil.setCubeName(seg.getCubeInstance().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        result.setName(seg.getCubeInstance().getName() + " - " + seg.getName() + " - " + jobType + " - " + format.format(new Date(System.currentTimeMillis())));
        result.setSubmitter(submitter);
        result.setNotifyList(seg.getCubeInstance().getDescriptor().getNotifyList());
        return result;
    }

    void setDeployEnvName(String name) {
        this.setParam(DEPLOY_ENV_NAME, name);
    }

    public static String getDeployEnvName() {
        return DEPLOY_ENV_NAME;
    }

    void setProjectName(String name) {
        this.setParam(PROJECT_INSTANCE_NAME, name);
    }

    public static String getProjectName() {
        return PROJECT_INSTANCE_NAME;
    }

    @Override
    protected Pair<String, String> formatNotifications(ExecutableContext context, ExecutableState state) {
        String logMsg;
        CubeInstance cubeInstance = CubeManager.getInstance(context.getConfig()).getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        Output output = this.jobService.getOutput(this.getId());
        state = output.getState();
        if (state != ExecutableState.ERROR && !cubeInstance.getDescriptor().getStatusNeedNotify().contains(state.toString())) {
            logger.info("state:" + (Object)((Object)state) + " no need to notify users");
            return null;
        }
        switch (state) {
            case ERROR: {
                logMsg = output.getVerboseMsg();
                break;
            }
            case DISCARDED: {
                logMsg = "job has been discarded";
                break;
            }
            case SUCCEED: {
                logMsg = "job has succeeded";
                break;
            }
            default: {
                return null;
            }
        }
        String content = "<div><b>Build Result of Job ${job_name}</b><pre><ul><li>Build Result: <b>${result}</b></li><li>Job Engine: ${job_engine}</li><li>Env: ${env_name}</li><li>Project: ${project_name}</li><li>Cube Name: ${cube_name}</li><li>Source Records Count: ${source_records_count}</li><li>Start Time: ${start_time}</li><li>Duration: ${duration}</li><li>MR Waiting: ${mr_waiting}</li><li>Last Update Time: ${last_update_time}</li><li>Submitter: ${submitter}</li><li>Error Log: ${error_log}</li></ul></pre><div/>";
        content = content.replaceAll("\\$\\{job_name\\}", this.getName());
        content = content.replaceAll("\\$\\{result\\}", state.toString());
        content = content.replaceAll("\\$\\{env_name\\}", CubingJob.getDeployEnvName());
        content = content.replaceAll("\\$\\{project_name\\}", CubingJob.getProjectName());
        content = content.replaceAll("\\$\\{cube_name\\}", CubingExecutableUtil.getCubeName(this.getParams()));
        content = content.replaceAll("\\$\\{source_records_count\\}", String.valueOf(this.findSourceRecordCount()));
        content = content.replaceAll("\\$\\{start_time\\}", new Date(this.getStartTime()).toString());
        content = content.replaceAll("\\$\\{duration\\}", this.getDuration() / 60000L + "mins");
        content = content.replaceAll("\\$\\{mr_waiting\\}", this.getMapReduceWaitTime() / 60000L + "mins");
        content = content.replaceAll("\\$\\{last_update_time\\}", new Date(this.getLastModified()).toString());
        content = content.replaceAll("\\$\\{submitter\\}", StringUtil.noBlank(this.getSubmitter(), "missing submitter"));
        content = content.replaceAll("\\$\\{error_log\\}", Matcher.quoteReplacement(StringUtil.noBlank(logMsg, "no error message")));
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            content = content.replaceAll("\\$\\{job_engine\\}", inetAddress.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        String title = "[" + state.toString() + "] - [" + CubingJob.getDeployEnvName() + "] - [" + CubingJob.getProjectName() + "] - " + CubingExecutableUtil.getCubeName(this.getParams());
        return Pair.of((Object)title, (Object)content);
    }

    @Override
    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        AbstractExecutable task;
        ExecutableState status;
        long time = 0L;
        Iterator<AbstractExecutable> i$ = this.getTasks().iterator();
        while (i$.hasNext() && (status = (task = i$.next()).getStatus()) == ExecutableState.SUCCEED) {
            if (!(task instanceof MapReduceExecutable)) continue;
            time += ((MapReduceExecutable)task).getMapReduceWaitTime();
        }
        this.setMapReduceWaitTime(time);
        super.onExecuteFinished(result, executableContext);
    }

    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong(MAP_REDUCE_WAIT_TIME, 0L);
    }

    public void setMapReduceWaitTime(long t) {
        this.addExtraInfo(MAP_REDUCE_WAIT_TIME, t + "");
    }

    public void setAlgorithm(AlgorithmEnum alg) {
        this.addExtraInfo("algorithm", alg.name());
    }

    public AlgorithmEnum getAlgorithm() {
        String alg = this.getExtraInfo().get("algorithm");
        return alg == null ? null : AlgorithmEnum.valueOf(alg);
    }

    public boolean isLayerCubing() {
        return AlgorithmEnum.LAYER == this.getAlgorithm();
    }

    public boolean isInMemCubing() {
        return AlgorithmEnum.INMEM == this.getAlgorithm();
    }

    public long findSourceRecordCount() {
        return Long.parseLong(this.findExtraInfo(SOURCE_RECORD_COUNT, "0"));
    }

    public long findSourceSizeBytes() {
        return Long.parseLong(this.findExtraInfo(SOURCE_SIZE_BYTES, "0"));
    }

    public long findCubeSizeBytes() {
        return Long.parseLong(this.findExtraInfoBackward(CUBE_SIZE_BYTES, "0"));
    }

    public String findExtraInfo(String key, String dft) {
        return this.findExtraInfo(key, dft, false);
    }

    public String findExtraInfoBackward(String key, String dft) {
        return this.findExtraInfo(key, dft, true);
    }

    private String findExtraInfo(String key, String dft, boolean backward) {
        ArrayList<AbstractExecutable> tasks = new ArrayList<AbstractExecutable>(this.getTasks());
        if (backward) {
            Collections.reverse(tasks);
        }
        for (AbstractExecutable child : tasks) {
            Output output = executableManager.getOutput(child.getId());
            String value = output.getExtra().get(key);
            if (value == null) continue;
            return value;
        }
        return dft;
    }

    public static enum AlgorithmEnum {
        LAYER,
        INMEM;

    }
}

