/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.MergeCuboidJob;
import org.apache.kylin.engine.mr.steps.MergeStatisticsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMergeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchMergeJobBuilder2.class);
    private final IMROutput2.IMRBatchMergeOutputSide2 outputSide;

    public BatchMergeJobBuilder2(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        this.outputSide = MRUtil.getBatchMergeOutputSide2((CubeSegment)this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = (CubeSegment)this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        List<CubeSegment> mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)"there should be more than 2 segments to merge");
        ArrayList mergingSegmentIds = Lists.newArrayList();
        ArrayList mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
            mergingCuboidPaths.add(this.getCuboidRootPath(merging) + "*");
        }
        result.addTask(this.createMergeDictionaryStep(mergingSegmentIds));
        result.addTask(this.createMergeStatisticsStep(cubeSegment, mergingSegmentIds, this.getStatisticsPath(jobId)));
        this.addOtherStepBeforeMerge(result);
        this.outputSide.addStepPhase1_MergeDictionary(result);
        String formattedPath = StringUtil.join(mergingCuboidPaths, ",");
        result.addTask(this.createMergeCuboidDataStep(cubeSegment, formattedPath, cuboidRootPath));
        this.outputSide.addStepPhase2_BuildCube(result, cuboidRootPath);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    private MergeStatisticsStep createMergeStatisticsStep(CubeSegment seg, List<String> mergingSegmentIds, String mergedStatisticsFolder) {
        MergeStatisticsStep result = new MergeStatisticsStep();
        result.setName("Merge Cuboid Statistics");
        CubingExecutableUtil.setCubeName(seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        CubingExecutableUtil.setMergedStatisticsPath(mergedStatisticsFolder, result.getParams());
        return result;
    }

    private MapReduceExecutable createMergeCuboidDataStep(CubeSegment seg, String inputPath, String outputPath) {
        MapReduceExecutable mergeCuboidDataStep = new MapReduceExecutable();
        mergeCuboidDataStep.setName("Merge Cuboid Data");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, seg.getRealization().getDataModelDesc());
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "cubename", seg.getCubeInstance().getName());
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "segmentname", seg.getName());
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "input", inputPath);
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Merge_Cuboid_" + seg.getCubeInstance().getName() + "_Step");
        mergeCuboidDataStep.setMapReduceParams(cmd.toString());
        mergeCuboidDataStep.setMapReduceJobClass(MergeCuboidJob.class);
        return mergeCuboidDataStep;
    }

    protected void addOtherStepBeforeMerge(CubingJob result) {
    }
}

