/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine;

import java.util.HashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.IBatchCubingEngine;
import org.apache.kylin.engine.IStreamingCubingEngine;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IEngineAware;

public class EngineFactory {
    private static ImplementationSwitch<IBatchCubingEngine> batchEngines;
    private static ImplementationSwitch<IStreamingCubingEngine> streamingEngines;

    public static IBatchCubingEngine batchEngine(IEngineAware aware) {
        return batchEngines.get(aware.getEngineType());
    }

    public static IStreamingCubingEngine streamingEngine(IEngineAware aware) {
        return streamingEngines.get(aware.getEngineType());
    }

    public static DefaultChainedExecutable createBatchCubingJob(CubeSegment newSegment, String submitter) {
        return EngineFactory.batchEngine(newSegment).createBatchCubingJob(newSegment, submitter);
    }

    public static DefaultChainedExecutable createBatchMergeJob(CubeSegment mergeSegment, String submitter) {
        return EngineFactory.batchEngine(mergeSegment).createBatchMergeJob(mergeSegment, submitter);
    }

    public static Runnable createStreamingCubingBuilder(CubeSegment seg) {
        return EngineFactory.streamingEngine(seg).createStreamingCubingBuilder(seg);
    }

    static {
        HashMap<Integer, String> impls = new HashMap<Integer, String>();
        impls.put(0, KylinConfig.getInstanceFromEnv().getMRBatchEngineV1Class());
        impls.put(2, KylinConfig.getInstanceFromEnv().getMRBatchEngineV2Class());
        batchEngines = new ImplementationSwitch<IBatchCubingEngine>(impls, IBatchCubingEngine.class);
        impls.clear();
        streamingEngines = new ImplementationSwitch<IStreamingCubingEngine>(impls, IStreamingCubingEngine.class);
    }
}

