/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.ReadableTable;

public abstract class LookupTable<T extends Comparable<T>> {
    protected TableDesc tableDesc;
    protected String[] keyColumns;
    protected ReadableTable table;
    protected ConcurrentHashMap<org.apache.kylin.common.util.Array<T>, T[]> data;

    public LookupTable(TableDesc tableDesc, String[] keyColumns, ReadableTable table) throws IOException {
        this.tableDesc = tableDesc;
        this.keyColumns = keyColumns;
        this.table = table;
        this.data = new ConcurrentHashMap();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException {
        int[] keyIndex = new int[this.keyColumns.length];
        for (int i = 0; i < this.keyColumns.length; ++i) {
            keyIndex[i] = this.tableDesc.findColumnByName(this.keyColumns[i]).getZeroBasedIndex();
        }
        try (ReadableTable.TableReader reader = this.table.getReader();){
            while (reader.next()) {
                this.initRow(reader.getRow(), keyIndex);
            }
        }
    }

    private void initRow(String[] cols, int[] keyIndex) {
        Comparable[] value = this.convertRow(cols);
        Comparable[] keyCols = (Comparable[])Array.newInstance(this.getType(), keyIndex.length);
        for (int i = 0; i < keyCols.length; ++i) {
            keyCols[i] = value[keyIndex[i]];
        }
        org.apache.kylin.common.util.Array<Comparable> key = new org.apache.kylin.common.util.Array<Comparable>(keyCols);
        if (this.data.containsKey(key)) {
            throw new IllegalStateException("Dup key found, key=" + this.toString((T)keyCols) + ", value1=" + this.toString((T)((Comparable[])this.data.get(key))) + ", value2=" + this.toString((T)value));
        }
        this.data.put(key, value);
    }

    protected abstract T[] convertRow(String[] var1);

    public T[] getRow(org.apache.kylin.common.util.Array<T> key) {
        return (Comparable[])this.data.get(key);
    }

    public Collection<T[]> getAllRows() {
        return this.data.values();
    }

    public List<T> scan(String col, List<T> values, String returnCol) {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        for (Comparable[] comparableArray : this.data.values()) {
            if (!values.contains(comparableArray[colIdx])) continue;
            result.add(comparableArray[returnIdx]);
        }
        return result;
    }

    public Pair<T, T> mapRange(String col, T beginValue, T endValue, String returnCol) {
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        Comparable returnBegin = null;
        Comparable returnEnd = null;
        for (Comparable[] comparableArray : this.data.values()) {
            if (!this.between(beginValue, comparableArray[colIdx], endValue)) continue;
            Comparable returnValue = comparableArray[returnIdx];
            if (returnBegin == null || returnValue.compareTo(returnBegin) < 0) {
                returnBegin = returnValue;
            }
            if (returnEnd != null && returnValue.compareTo(returnEnd) <= 0) continue;
            returnEnd = returnValue;
        }
        if (returnBegin == null && returnEnd == null) {
            return null;
        }
        return Pair.newPair(returnBegin, returnEnd);
    }

    public Set<T> mapValues(String col, Set<T> values, String returnCol) {
        int colIdx = this.tableDesc.findColumnByName(col).getZeroBasedIndex();
        int returnIdx = this.tableDesc.findColumnByName(returnCol).getZeroBasedIndex();
        HashSet result = Sets.newHashSetWithExpectedSize((int)values.size());
        for (Comparable[] comparableArray : this.data.values()) {
            if (!values.contains(comparableArray[colIdx])) continue;
            result.add(comparableArray[returnIdx]);
        }
        return result;
    }

    private boolean between(T beginValue, T v, T endValue) {
        return !(beginValue != null && beginValue.compareTo(v) > 0 || endValue != null && v.compareTo(endValue) > 0);
    }

    public String toString() {
        return "LookupTable [path=" + this.table + "]";
    }

    protected String toString(T[] cols) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.toString(cols[i]));
        }
        b.append("]");
        return b.toString();
    }

    protected abstract String toString(T var1);

    public abstract Class<?> getType();

    public void dump() {
        for (org.apache.kylin.common.util.Array key : this.data.keySet()) {
            System.out.println(this.toString((T)((Comparable[])key.data)) + " => " + this.toString((T)((Comparable[])this.data.get(key))));
        }
    }
}

