/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dimension.Dictionary;

public class DateStrDictionary
extends Dictionary<String> {
    static final int ID_9999_12_31 = 3652426;
    private String pattern;
    private int baseId;
    private int maxId;

    public DateStrDictionary() {
        this.init("yyyy-MM-dd", 0);
    }

    public DateStrDictionary(String datePattern, int baseId) {
        this.init(datePattern, baseId);
    }

    private void init(String datePattern, int baseId) {
        this.pattern = datePattern;
        this.baseId = baseId;
        this.maxId = baseId + 3652426;
    }

    @Override
    public int getMinId() {
        return this.baseId;
    }

    @Override
    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public int getSizeOfId() {
        return 3;
    }

    @Override
    public int getSizeOfValue() {
        return this.pattern.length();
    }

    @Override
    protected boolean isNullByteForm(byte[] value, int offset, int len) {
        return value == null || len == 0;
    }

    @Override
    protected final int getIdFromValueImpl(String value, int roundFlag) {
        Date date = DateFormat.stringToDate(value, this.pattern);
        int id = this.calcIdFromSeqNo(this.getNumOfDaysSince0000(date));
        if (id < this.baseId || id > this.maxId) {
            throw new IllegalArgumentException("'" + value + "' encodes to '" + id + "' which is out of range [" + this.baseId + "," + this.maxId + "]");
        }
        return id;
    }

    @Override
    protected final String getValueFromIdImpl(int id) {
        if (id < this.baseId || id > this.maxId) {
            throw new IllegalArgumentException("ID '" + id + "' is out of range [" + this.baseId + "," + this.maxId + "]");
        }
        Date d = this.getDateFromNumOfDaysSince0000(this.calcSeqNoFromId(id));
        return DateFormat.dateToString(d, this.pattern);
    }

    private int getNumOfDaysSince0000(Date d) {
        return (int)(d.getTime() / 86400000L + 719530L);
    }

    private Date getDateFromNumOfDaysSince0000(int n) {
        long millis = ((long)n - 719530L) * 86400000L;
        return new Date(millis);
    }

    @Override
    protected final int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
        try {
            return this.getIdFromValue(new String(value, offset, len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final byte[] getValueBytesFromIdImpl(int id) {
        byte[] bytes;
        String date = (String)this.getValueFromId(id);
        try {
            bytes = date.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    @Override
    protected final int getValueBytesFromIdImpl(int id, byte[] returnValue, int offset) {
        byte[] bytes = this.getValueBytesFromIdImpl(id);
        System.arraycopy(bytes, 0, returnValue, offset, bytes.length);
        return bytes.length;
    }

    private int calcIdFromSeqNo(int seq) {
        return seq < 0 ? seq : this.baseId + seq;
    }

    private int calcSeqNoFromId(int id) {
        return id - this.baseId;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.pattern);
        out.writeInt(this.baseId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String pattern = in.readUTF();
        int baseId = in.readInt();
        this.init(pattern, baseId);
    }

    public int hashCode() {
        return 31 * this.baseId + this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateStrDictionary)) {
            return false;
        }
        DateStrDictionary that = (DateStrDictionary)o;
        return StringUtils.equals((String)this.pattern, (String)that.pattern) && this.baseId == that.baseId;
    }

    @Override
    public boolean contains(Dictionary<?> other) {
        return this.equals(other);
    }

    @Override
    public void dump(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        return "DateStrDictionary [pattern=" + this.pattern + ", baseId=" + this.baseId + "]";
    }
}

