/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.filter.BuildInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.ITupleFilterTransformer;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInFunctionTransformer
implements ITupleFilterTransformer {
    public static final Logger logger = LoggerFactory.getLogger(BuildInFunctionTransformer.class);
    private IDimensionEncodingMap dimEncMap;

    public BuildInFunctionTransformer(IDimensionEncodingMap dimEncMap) {
        this.dimEncMap = dimEncMap;
    }

    @Override
    public TupleFilter transform(TupleFilter tupleFilter) {
        TupleFilter translated = null;
        if (tupleFilter instanceof CompareTupleFilter) {
            translated = this.translateCompareTupleFilter((CompareTupleFilter)tupleFilter);
            if (translated != null) {
                logger.info("Translated {" + tupleFilter + "} to IN clause: {" + translated + "}");
            }
        } else if (tupleFilter instanceof BuildInFunctionTupleFilter) {
            translated = this.translateFunctionTupleFilter((BuildInFunctionTupleFilter)tupleFilter);
            if (translated != null) {
                logger.info("Translated {" + tupleFilter + "} to IN clause: {" + translated + "}");
            }
        } else if (tupleFilter instanceof LogicalTupleFilter) {
            ListIterator<? extends TupleFilter> childIterator = tupleFilter.getChildren().listIterator();
            while (childIterator.hasNext()) {
                TupleFilter transformed = this.transform(childIterator.next());
                if (transformed == null) continue;
                childIterator.set(transformed);
            }
        }
        return translated == null ? tupleFilter : translated;
    }

    private TupleFilter translateFunctionTupleFilter(BuildInFunctionTupleFilter buildInFunctionTupleFilter) {
        if (!buildInFunctionTupleFilter.isValid()) {
            return null;
        }
        TblColRef columnRef = buildInFunctionTupleFilter.getColumn();
        Dictionary<String> dict = this.dimEncMap.getDictionary(columnRef);
        if (dict == null) {
            return null;
        }
        CompareTupleFilter translated = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
        translated.addChild(new ColumnTupleFilter(columnRef));
        try {
            for (int i = dict.getMinId(); i <= dict.getMaxId(); ++i) {
                String dictVal = dict.getValueFromId(i);
                if (!((Boolean)buildInFunctionTupleFilter.invokeFunction(dictVal)).booleanValue()) continue;
                translated.addChild(new ConstantTupleFilter(dictVal));
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return null;
        }
        return translated;
    }

    private TupleFilter translateCompareTupleFilter(CompareTupleFilter compTupleFilter) {
        if (compTupleFilter.getFunction() == null || !(compTupleFilter.getFunction() instanceof BuildInFunctionTupleFilter)) {
            return null;
        }
        BuildInFunctionTupleFilter buildInFunctionTupleFilter = (BuildInFunctionTupleFilter)compTupleFilter.getFunction();
        if (!buildInFunctionTupleFilter.isValid()) {
            return null;
        }
        TblColRef columnRef = buildInFunctionTupleFilter.getColumn();
        Dictionary<String> dict = this.dimEncMap.getDictionary(columnRef);
        if (dict == null) {
            return null;
        }
        CompareTupleFilter translated = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
        translated.addChild(new ColumnTupleFilter(columnRef));
        try {
            ArrayList inValues = Lists.newArrayList();
            for (int i = dict.getMinId(); i <= dict.getMaxId(); ++i) {
                String dictVal = dict.getValueFromId(i);
                Object computedVal = buildInFunctionTupleFilter.invokeFunction(dictVal);
                Class clazz = Primitives.wrap(computedVal.getClass());
                Object targetVal = compTupleFilter.getFirstValue();
                if (Primitives.isWrapperType((Class)clazz)) {
                    targetVal = clazz.cast(clazz.getDeclaredMethod("valueOf", String.class).invoke(null, compTupleFilter.getFirstValue()));
                }
                int comp = ((Comparable)computedVal).compareTo(targetVal);
                boolean compResult = false;
                switch (compTupleFilter.getOperator()) {
                    case EQ: {
                        compResult = comp == 0;
                        break;
                    }
                    case NEQ: {
                        compResult = comp != 0;
                        break;
                    }
                    case LT: {
                        compResult = comp < 0;
                        break;
                    }
                    case LTE: {
                        compResult = comp <= 0;
                        break;
                    }
                    case GT: {
                        compResult = comp > 0;
                        break;
                    }
                    case GTE: {
                        compResult = comp >= 0;
                        break;
                    }
                    case IN: {
                        compResult = compTupleFilter.getValues().contains(computedVal.toString());
                        break;
                    }
                    case NOTIN: {
                        compResult = !compTupleFilter.getValues().contains(computedVal.toString());
                        break;
                    }
                }
                if (!compResult) continue;
                inValues.add(dictVal);
            }
            translated.addChild(new ConstantTupleFilter(inValues));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return null;
        }
        return translated;
    }
}

