/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;

public class AggregationGroupRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        this.inner(cube, context);
    }

    private int count(String[][] input) {
        if (input == null) {
            return 0;
        }
        return input.length;
    }

    private void inner(CubeDesc cube, ValidateContext context) {
        int maxSize = this.getMaxAgrGroupSize();
        int index = 0;
        for (AggregationGroup agg : cube.getAggregationGroups()) {
            if (agg.getIncludes() == null) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " includes field not set");
                continue;
            }
            if (agg.getSelectRule() == null) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " select rule field not set");
                continue;
            }
            TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getIncludes() != null) {
                for (String include : agg.getIncludes()) {
                    includeDims.add(include);
                }
            }
            TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().mandatory_dims != null) {
                for (String m : agg.getSelectRule().mandatory_dims) {
                    mandatoryDims.add(m);
                }
            }
            TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().hierarchy_dims != null) {
                String[][] arr$ = agg.getSelectRule().hierarchy_dims;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] ss;
                    for (String s : ss = arr$[i$]) {
                        hierarchyDims.add(s);
                    }
                }
            }
            TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().joint_dims != null) {
                String[][] arr$ = agg.getSelectRule().joint_dims;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] ss;
                    for (String s : ss = arr$[i$]) {
                        jointDims.add(s);
                    }
                }
            }
            if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " Include dims not containing all the used dims");
                continue;
            }
            TreeSet<String> normalDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            normalDims.addAll(includeDims);
            normalDims.removeAll(mandatoryDims);
            normalDims.removeAll(hierarchyDims);
            normalDims.removeAll(jointDims);
            int normalDimSize = normalDims.size();
            int hierarchySize = this.count(agg.getSelectRule().hierarchy_dims);
            int jointSize = this.count(agg.getSelectRule().joint_dims);
            if (mandatoryDims.size() + normalDimSize + hierarchySize + jointSize > maxSize) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " has too many dimensions");
                continue;
            }
            if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dims overlap with hierarchy dims");
                continue;
            }
            if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dims overlap with joint dims");
                continue;
            }
            int jointDimNum = 0;
            if (agg.getSelectRule().joint_dims != null) {
                for (String[] joints : agg.getSelectRule().joint_dims) {
                    TreeSet<String> oneJoint = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    for (String s : joints) {
                        oneJoint.add(s);
                    }
                    if (oneJoint.size() < 2) {
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " require at least 2 dims in a joint");
                        continue;
                    }
                    jointDimNum += oneJoint.size();
                    int overlapHierarchies = 0;
                    if (agg.getSelectRule().hierarchy_dims == null) continue;
                    for (String[] oneHierarchy : agg.getSelectRule().hierarchy_dims) {
                        TreeSet share = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                        share.addAll(CollectionUtils.intersection(oneJoint, Arrays.asList(oneHierarchy)));
                        if (!share.isEmpty()) {
                            ++overlapHierarchies;
                        }
                        if (share.size() <= 1) continue;
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint columns overlap with more than 1 dim in same hierarchy");
                    }
                    if (overlapHierarchies <= true) continue;
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint columns overlap with more than 1 hierarchies");
                }
                if (jointDimNum != jointDims.size()) {
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " a dim exist in more than one joint");
                    continue;
                }
            }
            ++index;
        }
    }

    protected int getMaxAgrGroupSize() {
        return KylinConfig.getInstanceFromEnv().getCubeAggrGroupMaxSize();
    }
}

